/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.WorldTools;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.controller.TileEntityController;
import mcjty.xnet.blocks.router.TileEntityRouter;
import mcjty.xnet.logic.ConnectorIterator;
import mcjty.xnet.logic.RouterIterator;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LogicTools {
    @Nullable
    public static TileEntityController getControllerForConnector(@Nonnull World world, @Nonnull BlockPos connectorPos) {
        BlockPos controllerPos = LogicTools.getControllerPosForConnector(world, connectorPos);
        if (controllerPos == null) {
            return null;
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)controllerPos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(controllerPos);
        if (te instanceof TileEntityController) {
            return (TileEntityController)te;
        }
        return null;
    }

    @Nullable
    public static BlockPos getControllerPosForConnector(@Nonnull World world, @Nonnull BlockPos connectorPos) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(world).getWorldBlob(world);
        NetworkId networkId = worldBlob.getNetworkAt(connectorPos);
        if (networkId == null) {
            return null;
        }
        return worldBlob.getProviderPosition(networkId);
    }

    public static Stream<BlockPos> consumers(@Nonnull World world, @Nonnull NetworkId networkId) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(world).getWorldBlob(world);
        return worldBlob.getConsumers(networkId).stream();
    }

    public static Stream<BlockPos> connectors(@Nonnull World world, @Nonnull BlockPos pos) {
        return new ConnectorIterator(world, pos, false).stream();
    }

    public static Stream<BlockPos> routingConnectors(@Nonnull World world, @Nonnull BlockPos pos) {
        return new ConnectorIterator(world, pos, true).stream();
    }

    public static Stream<TileEntityRouter> routers(@Nonnull World world, @Nonnull BlockPos pos) {
        return new RouterIterator(world, pos).stream();
    }

    public static Stream<BlockPos> connectedBlocks(@Nonnull World world, @Nonnull NetworkId networkId, @Nonnull Set<SidedConsumer> consumers) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(world).getWorldBlob(world);
        return consumers.stream().map(sidedConsumer -> {
            BlockPos consumerPos = LogicTools.findConsumerPosition(networkId, worldBlob, sidedConsumer.getConsumerId());
            if (consumerPos != null) {
                return consumerPos.func_177972_a(sidedConsumer.getSide());
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public static Stream<TileEntityController> controllers(@Nonnull World world, @Nonnull NetworkId networkId) {
        return LogicTools.connectedBlocks(world, networkId).filter(pos -> world.func_175625_s(pos) instanceof TileEntityController).map(pos -> (TileEntityController)world.func_175625_s(pos));
    }

    public static Stream<TileEntityRouter> routers(@Nonnull World world, @Nonnull NetworkId networkId) {
        return LogicTools.connectedBlocks(world, networkId).filter(pos -> world.func_175625_s(pos) instanceof TileEntityRouter).map(pos -> (TileEntityRouter)world.func_175625_s(pos));
    }

    public static Stream<BlockPos> connectedBlocks(@Nonnull World world, @Nonnull NetworkId networkId) {
        return LogicTools.consumers(world, networkId).map(blockPos -> Arrays.stream(EnumFacing.field_82609_l).filter(facing -> ConnectorBlock.isConnectable((IBlockAccess)world, blockPos, facing)).map(arg_0 -> ((BlockPos)blockPos).func_177972_a(arg_0))).flatMap(s -> s);
    }

    @Nullable
    public static BlockPos findConsumerPosition(@Nonnull NetworkId networkId, @Nonnull WorldBlob worldBlob, @Nonnull ConsumerId consumerId) {
        Set<BlockPos> consumers = worldBlob.getConsumers(networkId);
        for (BlockPos pos : consumers) {
            ConsumerId c = worldBlob.getConsumerAt(pos);
            if (!consumerId.equals(c)) continue;
            return pos;
        }
        return null;
    }
}

