/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.router;

import java.awt.Rectangle;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.blocks.router.TileEntityRouter;
import mcjty.xnet.clientinfo.ControllerChannelClientInfo;
import mcjty.xnet.network.PacketGetLocalChannelsRouter;
import mcjty.xnet.network.PacketGetRemoteChannelsRouter;
import mcjty.xnet.network.XNetMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiRouter
extends GenericGuiContainer<TileEntityRouter> {
    public static final int SIDEWIDTH = 80;
    public static final int WIDTH = 256;
    public static final int HEIGHT = 236;
    private static final ResourceLocation mainBackground = new ResourceLocation("xnet", "textures/gui/router.png");
    private static final ResourceLocation sideBackground = new ResourceLocation("xnet", "textures/gui/sidegui.png");
    private WidgetList localChannelList;
    private WidgetList remoteChannelList;
    public static List<ControllerChannelClientInfo> fromServer_localChannels = null;
    public static List<ControllerChannelClientInfo> fromServer_remoteChannels = null;
    private boolean needsRefresh = true;
    private int listDirty;

    public GuiRouter(TileEntityRouter router, EmptyContainer container) {
        super((ModBase)XNet.instance, XNetMessages.INSTANCE, (GenericTileEntity)router, (Container)container, 0, "router");
        this.field_146999_f = 256;
        this.field_147000_g = 236;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackgrounds(sideBackground, mainBackground)).setBackgroundLayout(true, 80);
        toplevel.setBounds(new Rectangle(this.field_147003_i - 80, this.field_147009_r, this.field_146999_f + 80, this.field_147000_g));
        toplevel.addChild((Widget)this.initLocalChannelListPanel());
        toplevel.addChild((Widget)this.initRemoteChannelListPanel());
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText("Local Channels").setColor(-14531414).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(6, 8, 166, 13)));
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText("Remote Channels").setColor(-14531414).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(172, 8, 164, 13)));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        this.refresh();
        this.listDirty = 0;
    }

    private void updatePublish(BlockPos pos, int index, String name) {
        this.sendServerCommand(XNetMessages.INSTANCE, "updateName", new Argument[]{new Argument("pos", pos), new Argument("channel", index), new Argument("name", name)});
    }

    private void refresh() {
        fromServer_localChannels = null;
        fromServer_remoteChannels = null;
        this.needsRefresh = true;
        this.listDirty = 3;
        this.requestListsIfNeeded();
    }

    private Panel initLocalChannelListPanel() {
        this.localChannelList = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
            }
        });
        this.localChannelList.setPropagateEventsToChildren(true);
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollable((Scrollable)this.localChannelList);
        return (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChild((Widget)this.localChannelList)).addChild((Widget)listSlider)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(2, 28, 167, 208));
    }

    private Panel initRemoteChannelListPanel() {
        this.remoteChannelList = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
            }
        });
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollable((Scrollable)this.remoteChannelList);
        return (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChild((Widget)this.remoteChannelList)).addChild((Widget)listSlider)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(169, 28, 167, 208));
    }

    private boolean listsReady() {
        return fromServer_localChannels != null && fromServer_remoteChannels != null;
    }

    private void populateList() {
        if (!this.listsReady()) {
            return;
        }
        if (!this.needsRefresh) {
            return;
        }
        this.needsRefresh = false;
        this.localChannelList.removeChildren();
        this.localChannelList.setRowheight(40);
        int sel = this.localChannelList.getSelected();
        for (ControllerChannelClientInfo channel : fromServer_localChannels) {
            this.localChannelList.addChild((Widget)this.makeChannelLine(channel, true));
        }
        this.localChannelList.setSelected(sel);
        this.remoteChannelList.removeChildren();
        this.remoteChannelList.setRowheight(40);
        sel = this.remoteChannelList.getSelected();
        for (ControllerChannelClientInfo channel : fromServer_remoteChannels) {
            this.remoteChannelList.addChild((Widget)this.makeChannelLine(channel, false));
        }
        this.remoteChannelList.setSelected(sel);
    }

    private Panel makeChannelLine(ControllerChannelClientInfo channel, boolean local) {
        String name = channel.getChannelName();
        String publishedName = channel.getPublishedName();
        BlockPos controllerPos = channel.getPos();
        IChannelType type = channel.getChannelType();
        int index = channel.getIndex();
        Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setDesiredHeight(30);
        Panel panel1 = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 160, 13));
        panel1.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Ch").setColor(-14531414));
        panel1.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(name));
        panel1.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(">").setColor(-14531414));
        if (local) {
            TextField pubName = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setText(publishedName).setDesiredWidth(50)).setDesiredHeight(13)).addTextEvent((parent, newText) -> this.updatePublish(controllerPos, index, newText));
            panel1.addChild((Widget)pubName);
        } else {
            panel1.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(publishedName).setColor(-13369600));
        }
        Panel panel2 = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 13, 160, 13));
        panel2.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Pos").setColor(-14531414));
        panel2.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(BlockPosTools.toString((BlockPos)controllerPos)));
        Panel panel3 = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 26, 160, 13));
        panel3.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Index").setColor(-14531414));
        panel3.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(index + " (" + type.getName() + ")"));
        ((Panel)((Panel)panel.addChild((Widget)panel1)).addChild((Widget)panel2)).addChild((Widget)panel3);
        return panel;
    }

    private void requestListsIfNeeded() {
        if (fromServer_localChannels != null && fromServer_remoteChannels != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            XNetMessages.INSTANCE.sendToServer((IMessage)new PacketGetLocalChannelsRouter(((TileEntityRouter)this.tileEntity).func_174877_v()));
            XNetMessages.INSTANCE.sendToServer((IMessage)new PacketGetRemoteChannelsRouter(((TileEntityRouter)this.tileEntity).func_174877_v()));
            this.listDirty = 10;
        }
    }

    protected void func_146976_a(float v, int x1, int x2) {
        this.requestListsIfNeeded();
        this.populateList();
        this.drawWindow();
    }
}

