/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.generic;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.CompatLayer;
import mcjty.lib.compat.CompatBlock;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.XNet;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.blocks.cables.ConnectorType;
import mcjty.xnet.blocks.facade.FacadeProperty;
import mcjty.xnet.blocks.facade.IFacadeSupport;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.generic.UnlistedPropertyBlockType;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GenericCableBlock
extends CompatBlock
implements WailaInfoProvider,
TOPInfoProvider {
    public static final UnlistedPropertyBlockType NORTH = new UnlistedPropertyBlockType("north");
    public static final UnlistedPropertyBlockType SOUTH = new UnlistedPropertyBlockType("south");
    public static final UnlistedPropertyBlockType WEST = new UnlistedPropertyBlockType("west");
    public static final UnlistedPropertyBlockType EAST = new UnlistedPropertyBlockType("east");
    public static final UnlistedPropertyBlockType UP = new UnlistedPropertyBlockType("up");
    public static final UnlistedPropertyBlockType DOWN = new UnlistedPropertyBlockType("down");
    public static final FacadeProperty FACADEID = new FacadeProperty("facadeid");
    public static final PropertyEnum<CableColor> COLOR = PropertyEnum.func_177709_a((String)"color", CableColor.class);
    public static final AxisAlignedBB AABB_EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AxisAlignedBB AABB_CENTER = new AxisAlignedBB(0.4, 0.4, 0.4, 0.6, 0.6, 0.6);
    public static final AxisAlignedBB[] AABBS = new AxisAlignedBB[]{new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 0.4, 0.6), new AxisAlignedBB(0.4, 0.6, 0.4, 0.6, 1.0, 0.6), new AxisAlignedBB(0.4, 0.4, 0.0, 0.6, 0.6, 0.4), new AxisAlignedBB(0.4, 0.4, 0.6, 0.6, 0.6, 1.0), new AxisAlignedBB(0.0, 0.4, 0.4, 0.4, 0.6, 0.6), new AxisAlignedBB(0.6, 0.4, 0.4, 1.0, 0.6, 0.6)};
    public static final AxisAlignedBB[] AABBS_CONNECTOR = new AxisAlignedBB[]{new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.1, 0.8), new AxisAlignedBB(0.2, 0.9, 0.2, 0.8, 1.0, 0.8), new AxisAlignedBB(0.2, 0.2, 0.0, 0.8, 0.8, 0.1), new AxisAlignedBB(0.2, 0.2, 0.9, 0.8, 0.8, 1.0), new AxisAlignedBB(0.0, 0.2, 0.2, 0.1, 0.8, 0.8), new AxisAlignedBB(0.9, 0.2, 0.2, 1.0, 0.8, 0.8)};

    public GenericCableBlock(Material material, String name) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149663_c("xnet." + name);
        this.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)this.createItemBlock(), (ResourceLocation)this.getRegistryName());
        this.func_149647_a(XNet.tabXNet);
        this.func_180632_j(this.func_176223_P().func_177226_a(COLOR, (Comparable)((Object)CableColor.BLUE)));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack item = super.func_185473_a(worldIn, pos, state);
        return this.updateColorInStack(item, (CableColor)((Object)state.func_177229_b(COLOR)));
    }

    protected ItemStack updateColorInStack(ItemStack item, CableColor color) {
        if (color != null) {
            if (item.func_77978_p() == null) {
                item.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound display = new NBTTagCompound();
            String unlocname = this.func_149739_a() + "_" + color.func_176610_l() + ".name";
            if (CompatLayer.isV10()) {
                display.func_74778_a("Name", I18n.func_74838_a((String)unlocname));
            } else {
                display.func_74778_a("LocName", unlocname);
            }
            item.func_77978_p().func_74782_a("display", (NBTBase)display);
        }
        return item;
    }

    protected ItemBlock createItemBlock() {
        ItemBlock itemBlock = new ItemBlock((Block)this){

            public int func_77647_b(int damage) {
                return damage;
            }
        };
        itemBlock.func_77627_a(true);
        return itemBlock;
    }

    public int func_180651_a(IBlockState state) {
        return ((CableColor)((Object)state.func_177229_b(COLOR))).ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ResourceLocation name = this.getRegistryName();
        for (CableColor color : CableColor.VALUES) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)color.ordinal(), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(name.func_110624_b(), name.func_110623_a() + "item"), "color=" + color.name()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initItemModel() {
    }

    @Nullable
    protected IBlockState getMimicBlock(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof IFacadeSupport) {
            return ((IFacadeSupport)te).getMimicBlock();
        }
        return null;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return AABB_EMPTY;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        Vec3d vec3d1;
        if (this.getMimicBlock((IBlockAccess)world, pos) != null) {
            return this.originalCollisionRayTrace(blockState, world, pos, start, end);
        }
        Vec3d vec3d = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        RayTraceResult rc = this.checkIntersect(pos, vec3d, vec3d1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), AABB_CENTER);
        if (rc != null) {
            return rc;
        }
        CableColor color = (CableColor)((Object)blockState.func_177229_b(COLOR));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ConnectorType type = this.getConnectorType(color, (IBlockAccess)world, pos, facing);
            if (type != ConnectorType.NONE && (rc = this.checkIntersect(pos, vec3d, vec3d1, AABBS[facing.ordinal()])) != null) {
                return rc;
            }
            if (type != ConnectorType.BLOCK || (rc = this.checkIntersect(pos, vec3d, vec3d1, AABBS_CONNECTOR[facing.ordinal()])) == null) continue;
            return rc;
        }
        return null;
    }

    private RayTraceResult checkIntersect(BlockPos pos, Vec3d vec3d, Vec3d vec3d1, AxisAlignedBB boundingBox) {
        RayTraceResult raytraceresult = boundingBox.func_72327_a(vec3d, vec3d1);
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), raytraceresult.field_178784_b, pos);
    }

    protected RayTraceResult originalCollisionRayTrace(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return super.func_180636_a(blockState, world, pos, start, end);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(world).getWorldBlob(world);
        if (mode == ProbeMode.DEBUG) {
            Object colorId;
            BlobId blobId = worldBlob.getBlobAt(data.getPos());
            if (blobId != null) {
                probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
            }
            if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + ((ColorId)colorId).getId());
            }
        }
        Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
        for (NetworkId network : networks) {
            if (mode == ProbeMode.DEBUG) {
                probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + network.getId() + ", V: " + worldBlob.getNetworkVersion(network));
                continue;
            }
            probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + network.getId());
        }
        ConsumerId consumerId = worldBlob.getConsumerAt(data.getPos());
        if (consumerId != null) {
            probeInfo.text(TextStyleClass.LABEL + "Consumer: " + TextStyleClass.INFO + consumerId.getId());
        }
    }

    public boolean isAdvancedConnector() {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.originalOnBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            this.createCableSegment(world, pos, stack);
        }
    }

    protected void originalOnBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void createCableSegment(World world, BlockPos pos, ItemStack stack) {
        XNetBlobData blobData = XNetBlobData.getBlobData(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        CableColor color = (CableColor)((Object)world.func_180495_p(pos).func_177229_b(COLOR));
        worldBlob.createCableSegment(pos, new ColorId(color.ordinal() + 1));
        blobData.save(world);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.unlinkBlock(world, pos);
        this.originalBreakBlock(world, pos, state);
    }

    public void unlinkBlock(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.getBlobData(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            worldBlob.removeCableSegment(pos);
            blobData.save(world);
        }
    }

    protected void originalBreakBlock(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)((Object)CableColor.VALUES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((CableColor)((Object)state.func_177229_b(COLOR))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{COLOR};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN, FACADEID};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getStateInternal(state, world, pos);
    }

    public IBlockState getStateInternal(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        CableColor color = (CableColor)((Object)state.func_177229_b(COLOR));
        ConnectorType north = this.getConnectorType(color, world, pos, EnumFacing.NORTH);
        ConnectorType south = this.getConnectorType(color, world, pos, EnumFacing.SOUTH);
        ConnectorType west = this.getConnectorType(color, world, pos, EnumFacing.WEST);
        ConnectorType east = this.getConnectorType(color, world, pos, EnumFacing.EAST);
        ConnectorType up = this.getConnectorType(color, world, pos, EnumFacing.UP);
        ConnectorType down = this.getConnectorType(color, world, pos, EnumFacing.DOWN);
        return extendedBlockState.withProperty((IUnlistedProperty)NORTH, (Object)north).withProperty((IUnlistedProperty)SOUTH, (Object)south).withProperty((IUnlistedProperty)WEST, (Object)west).withProperty((IUnlistedProperty)EAST, (Object)east).withProperty((IUnlistedProperty)UP, (Object)up).withProperty((IUnlistedProperty)DOWN, (Object)down);
    }

    protected abstract ConnectorType getConnectorType(@Nonnull CableColor var1, IBlockAccess var2, BlockPos var3, EnumFacing var4);
}

