/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.controller.gui;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.lib.network.ArgumentType;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.MinecraftTools;
import mcjty.xnet.api.channels.RSMode;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.blocks.controller.gui.GuiController;
import mcjty.xnet.network.XNetMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractEditorPanel
implements IEditorGui {
    public static final int LEFTMARGIN = 3;
    public static final int TOPMARGIN = 3;
    private final Panel panel;
    private final Minecraft mc;
    private final GuiController gui;
    protected final Map<String, Object> data;
    protected final Map<String, Widget> components = new HashMap<String, Widget>();
    private int x;
    private int y;

    protected abstract void update(String var1, Object var2);

    public Widget getComponent(String tag) {
        return this.components.get(tag);
    }

    protected void performUpdate(Argument[] args, int i, String cmd) {
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof String) {
                args[i++] = new Argument(entry.getKey(), ArgumentType.TYPE_STRING, o);
                continue;
            }
            if (o instanceof Integer) {
                args[i++] = new Argument(entry.getKey(), ArgumentType.TYPE_INTEGER, o);
                continue;
            }
            if (o instanceof Boolean) {
                args[i++] = new Argument(entry.getKey(), ArgumentType.TYPE_BOOLEAN, o);
                continue;
            }
            if (o instanceof Double) {
                args[i++] = new Argument(entry.getKey(), ArgumentType.TYPE_DOUBLE, o);
                continue;
            }
            if (o instanceof ItemStack) {
                args[i++] = new Argument(entry.getKey(), ArgumentType.TYPE_STACK, o);
                continue;
            }
            args[i++] = new Argument(entry.getKey(), ArgumentType.TYPE_STRING, o);
        }
        this.gui.sendServerCommand(XNetMessages.INSTANCE, cmd, args);
        this.gui.refresh();
    }

    public AbstractEditorPanel(Panel panel, Minecraft mc, GuiController gui) {
        this.panel = panel;
        this.mc = mc;
        this.gui = gui;
        this.x = 3;
        this.y = 3;
        this.data = new HashMap<String, Object>();
    }

    @Override
    public IEditorGui move(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    @Override
    public IEditorGui move(int x) {
        this.x = x;
        return this;
    }

    @Override
    public IEditorGui shift(int x) {
        this.x += x;
        return this;
    }

    private void fitWidth(int w) {
        if (this.x + w > this.panel.getBounds().width) {
            this.nl();
        }
    }

    private String[] parseTooltips(String tooltip) {
        return StringUtils.split((String)tooltip, (char)'|');
    }

    @Override
    public IEditorGui label(String txt) {
        int w = this.mc.field_71466_p.func_78256_a(txt) + 5;
        this.fitWidth(w);
        Label label = new Label(this.mc, (Gui)this.gui).setText(txt);
        label.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.panel.addChild((Widget)label);
        this.x += w;
        return this;
    }

    @Override
    public IEditorGui text(String tag, String tooltip, String value, int width) {
        int w = width;
        this.fitWidth(w);
        TextField text = (TextField)((TextField)new TextField(this.mc, (Gui)this.gui).setText(value).setTooltips(this.parseTooltips(tooltip))).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.data.put(tag, value);
        text.addTextEnterEvent((parent, newText) -> this.update(tag, newText));
        text.addTextEvent((parent, newText) -> this.update(tag, newText));
        this.panel.addChild((Widget)text);
        this.components.put(tag, (Widget)text);
        this.x += w;
        return this;
    }

    private Integer parseInt(String i) {
        if (i == null || i.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public IEditorGui integer(String tag, String tooltip, Integer value, int width) {
        int w = width;
        this.fitWidth(w);
        TextField text = (TextField)((TextField)new TextField(this.mc, (Gui)this.gui).setText(value == null ? "" : value.toString()).setTooltips(this.parseTooltips(tooltip))).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.data.put(tag, value);
        text.addTextEnterEvent((parent, newText) -> this.update(tag, this.parseInt(newText)));
        text.addTextEvent((parent, newText) -> this.update(tag, this.parseInt(newText)));
        this.panel.addChild((Widget)text);
        this.components.put(tag, (Widget)text);
        this.x += w;
        return this;
    }

    private Double parseDouble(String i) {
        if (i == null || i.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(i);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public IEditorGui real(String tag, String tooltip, Double value, int width) {
        int w = width;
        this.fitWidth(w);
        TextField text = (TextField)((TextField)new TextField(this.mc, (Gui)this.gui).setText(value == null ? "" : value.toString()).setTooltips(this.parseTooltips(tooltip))).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.data.put(tag, value);
        text.addTextEnterEvent((parent, newText) -> this.update(tag, this.parseDouble(newText)));
        text.addTextEvent((parent, newText) -> this.update(tag, this.parseDouble(newText)));
        this.panel.addChild((Widget)text);
        this.components.put(tag, (Widget)text);
        this.x += w;
        return this;
    }

    @Override
    public IEditorGui toggle(String tag, String tooltip, boolean value) {
        int w = 12;
        this.fitWidth(w);
        ToggleButton toggle = (ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this.gui).setCheckMarker(true).setPressed(value).setTooltips(this.parseTooltips(tooltip))).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.data.put(tag, value);
        toggle.addButtonEvent(parent -> this.update(tag, toggle.isPressed()));
        this.panel.addChild((Widget)toggle);
        this.components.put(tag, (Widget)toggle);
        this.x += w;
        return this;
    }

    @Override
    public IEditorGui toggleText(String tag, String tooltip, String text, boolean value) {
        int w = this.mc.field_71466_p.func_78256_a(text) + 10;
        this.fitWidth(w);
        ToggleButton toggle = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this.gui).setCheckMarker(false).setPressed(value).setText(text)).setTooltips(this.parseTooltips(tooltip))).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.data.put(tag, value);
        toggle.addButtonEvent(parent -> this.update(tag, toggle.isPressed()));
        this.panel.addChild((Widget)toggle);
        this.components.put(tag, (Widget)toggle);
        this.x += w;
        return this;
    }

    @Override
    public IEditorGui colors(String tag, String tooltip, Integer current, Integer ... colors) {
        int w = 14;
        this.fitWidth(w);
        ColorChoiceLabel choice = (ColorChoiceLabel)((ColorChoiceLabel)new ColorChoiceLabel(this.mc, (Gui)this.gui).addColors(colors).setCurrentColor(current).setTooltips(this.parseTooltips(tooltip))).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.data.put(tag, current);
        choice.addChoiceEvent((parent, newChoice) -> this.update(tag, newChoice));
        this.panel.addChild((Widget)choice);
        this.components.put(tag, (Widget)choice);
        this.x += w;
        return this;
    }

    @Override
    public IEditorGui choices(String tag, String tooltip, String current, String ... values) {
        int w = 10;
        for (String s : values) {
            w = Math.max(w, this.mc.field_71466_p.func_78256_a(s) + 14);
        }
        this.fitWidth(w);
        ChoiceLabel choice = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.mc, (Gui)this.gui).addChoices(values).setChoice(current).setTooltips(this.parseTooltips(tooltip))).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.data.put(tag, current);
        choice.addChoiceEvent((parent, newChoice) -> this.update(tag, newChoice));
        this.panel.addChild((Widget)choice);
        this.components.put(tag, (Widget)choice);
        this.x += w;
        return this;
    }

    @Override
    public <T extends Enum<T>> IEditorGui choices(String tag, String tooltip, T current, T ... values) {
        String[] strings = new String[values.length];
        int i = 0;
        for (T s : values) {
            strings[i++] = StringUtils.capitalize((String)((Enum)s).toString().toLowerCase());
        }
        return this.choices(tag, tooltip, StringUtils.capitalize((String)current.toString().toLowerCase()), strings);
    }

    @Override
    public IEditorGui redstoneMode(String tag, RSMode current) {
        int w = 14;
        this.fitWidth(w);
        ImageChoiceLabel redstoneMode = new ImageChoiceLabel(this.mc, (Gui)this.gui).addChoice("Ignored", "Redstone mode:\nIgnored", GuiController.iconGuiElements, 1, 1).addChoice("Off", "Redstone mode:\nOff to activate", GuiController.iconGuiElements, 17, 1).addChoice("On", "Redstone mode:\nOn to activate", GuiController.iconGuiElements, 33, 1).addChoice("Pulse", "Do one operation\non a pulse", GuiController.iconGuiElements, 49, 1);
        switch (current) {
            case IGNORED: {
                redstoneMode.setCurrentChoice("Ignored");
                break;
            }
            case OFF: {
                redstoneMode.setCurrentChoice("Off");
                break;
            }
            case ON: {
                redstoneMode.setCurrentChoice("On");
                break;
            }
            case PULSE: {
                redstoneMode.setCurrentChoice("Pulse");
            }
        }
        redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y, w, 14));
        this.data.put(tag, current.name());
        redstoneMode.addChoiceEvent((parent, newChoice) -> this.update(tag, newChoice));
        this.panel.addChild((Widget)redstoneMode);
        this.components.put(tag, (Widget)redstoneMode);
        this.x += w;
        return this;
    }

    @Override
    public IEditorGui ghostSlot(final String tag, ItemStack stack) {
        int w = 16;
        this.fitWidth(w);
        final BlockRender blockRender = (BlockRender)((BlockRender)((BlockRender)((BlockRender)new BlockRender(this.mc, (Gui)this.gui).setRenderItem((Object)stack).setDesiredWidth(18)).setDesiredHeight(18)).setFilledRectThickness(-1)).setFilledBackground(-7829368);
        blockRender.addSelectionEvent(new BlockRenderEvent(){

            public void select(Widget widget) {
                ItemStack holding = MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x()).field_71071_by.func_70445_o();
                if (ItemStackTools.isEmpty((ItemStack)holding)) {
                    AbstractEditorPanel.this.update(tag, holding);
                    blockRender.setRenderItem(null);
                } else {
                    ItemStack copy = holding.func_77946_l();
                    ItemStackTools.setStackSize((ItemStack)copy, (int)1);
                    blockRender.setRenderItem((Object)copy);
                    AbstractEditorPanel.this.update(tag, copy);
                }
            }

            public void doubleClick(Widget widget) {
            }
        });
        blockRender.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.x, this.y - 1, 17, 17));
        this.data.put(tag, stack);
        this.panel.addChild((Widget)blockRender);
        this.components.put(tag, (Widget)blockRender);
        this.x += w;
        return this;
    }

    @Override
    public IEditorGui nl() {
        this.y += 16;
        this.x = 3;
        return this;
    }
}

