/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.controller;

import mcjty.lib.container.GenericGuiContainer;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.controller.ControllerContainer;
import mcjty.xnet.blocks.controller.TileEntityController;
import mcjty.xnet.blocks.controller.gui.GuiController;
import mcjty.xnet.blocks.generic.GenericXNetBlock;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControllerBlock
extends GenericXNetBlock<TileEntityController, ControllerContainer> {
    public static final PropertyBool ERROR = PropertyBool.func_177716_a((String)"error");

    public ControllerBlock() {
        super(Material.field_151573_f, TileEntityController.class, ControllerContainer.class, "controller", false);
    }

    public int getGuiID() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiController.class;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            this.findNeighbourConnector(world, pos);
        }
    }

    protected void clOnNeighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn) {
        super.clOnNeighborChanged(state, world, pos, blockIn);
        if (!world.field_72995_K) {
            this.findNeighbourConnector(world, pos);
        }
    }

    private void findNeighbourConnector(World world, BlockPos pos) {
        XNetBlobData blobData = XNetBlobData.getBlobData(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        ColorId oldColor = worldBlob.getColorAt(pos);
        ColorId newColor = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ColorId color;
            if (!(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof ConnectorBlock) || (color = worldBlob.getColorAt(pos.func_177972_a(facing))) == null) continue;
            if (color == oldColor) {
                return;
            }
            newColor = color;
        }
        if (newColor != null) {
            if (worldBlob.getBlobAt(pos) != null) {
                worldBlob.removeCableSegment(pos);
            }
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, newColor, networkId);
            blobData.save(world);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityController) {
                ((TileEntityController)te).setNetworkId(networkId);
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.getBlobData(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            worldBlob.removeCableSegment(pos);
            blobData.save(world);
        }
        super.func_180663_b(world, pos, state);
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        WorldBlob worldBlob = XNetBlobData.getBlobData(world).getWorldBlob(world);
        if (te instanceof TileEntityController) {
            TileEntityController controller = (TileEntityController)te;
            NetworkId networkId = controller.getNetworkId();
            if (networkId != null) {
                if (mode == ProbeMode.DEBUG) {
                    probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId() + ", V: " + worldBlob.getNetworkVersion(networkId));
                } else {
                    probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId());
                }
            }
            if (mode == ProbeMode.DEBUG) {
                String s = "";
                for (NetworkId id : controller.getNetworkChecker().getAffectedNetworks()) {
                    if ((s = s + id.getId() + " ").length() <= 15) continue;
                    probeInfo.text(TextStyleClass.LABEL + "InfNet: " + TextStyleClass.INFO + s);
                    s = "";
                }
                if (!s.isEmpty()) {
                    probeInfo.text(TextStyleClass.LABEL + "InfNet: " + TextStyleClass.INFO + s);
                }
            }
            if (controller.inError()) {
                probeInfo.text(TextStyleClass.ERROR + "Too many controllers on network!");
            }
        }
        if (mode == ProbeMode.DEBUG) {
            ColorId colorId;
            BlobId blobId = worldBlob.getBlobAt(data.getPos());
            if (blobId != null) {
                probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
            }
            if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + colorId.getId());
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        boolean error = false;
        if (te instanceof TileEntityController) {
            error = ((TileEntityController)te).inError();
        }
        return state.func_177226_a((IProperty)ERROR, (Comparable)Boolean.valueOf(error));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ERROR});
    }
}

