/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.cables;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.XNet;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.blocks.cables.ConnectorTileEntity;
import mcjty.xnet.blocks.cables.ConnectorType;
import mcjty.xnet.blocks.cables.NetCableBlock;
import mcjty.xnet.blocks.cables.NetCableSetup;
import mcjty.xnet.blocks.controller.TileEntityController;
import mcjty.xnet.blocks.facade.FacadeBlockId;
import mcjty.xnet.blocks.facade.FacadeItemBlock;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.generic.GenericCableBakedModel;
import mcjty.xnet.blocks.generic.GenericCableBlock;
import mcjty.xnet.blocks.router.TileEntityRouter;
import mcjty.xnet.config.GeneralConfiguration;
import mcjty.xnet.init.ModBlocks;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import org.lwjgl.input.Keyboard;

public class ConnectorBlock
extends GenericCableBlock
implements ITileEntityProvider {
    public static final String CONNECTOR = "connector";

    public ConnectorBlock() {
        this(CONNECTOR);
    }

    public ConnectorBlock(String name) {
        super(Material.field_151573_f, name);
        this.initTileEntity();
    }

    protected void initTileEntity() {
        GameRegistry.registerTileEntity(ConnectorTileEntity.class, (String)"xnet_connector");
    }

    protected void clGetSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (CableColor value : CableColor.VALUES) {
            if (value == CableColor.ROUTING && this == NetCableSetup.advancedConnectorBlock) continue;
            subItems.add(this.updateColorInStack(new ItemStack(itemIn, 1, value.ordinal()), value));
        }
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public TileEntity createTileEntity(World world, IBlockState metadata) {
        return new ConnectorTileEntity();
    }

    protected boolean clOnBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)XNet.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        ConnectorTileEntity connectorTileEntity;
        if (te instanceof ConnectorTileEntity && (connectorTileEntity = (ConnectorTileEntity)te).getMimicBlock() != null) {
            ItemStack item = new ItemStack((Block)ModBlocks.facadeBlock);
            FacadeItemBlock.setMimicBlock(item, connectorTileEntity.getMimicBlock());
            connectorTileEntity.setMimicBlock(null);
            ConnectorBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            return;
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)te;
            if (connectorTileEntity.getMimicBlock() == null) {
                this.func_176208_a(world, pos, state, player);
                return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            }
        } else {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        this.func_176208_a(world, pos, state, player);
        return true;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        String name;
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof ConnectorTileEntity && !(name = ((ConnectorTileEntity)te).getConnectorName()).isEmpty()) {
            probeInfo.text(TextStyleClass.LABEL + "Name: " + TextStyleClass.INFO + name);
        }
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        IBlockState mimicBlock = this.getMimicBlock(world, pos);
        if (mimicBlock != null) {
            return extendedBlockState.withProperty((IUnlistedProperty)FACADEID, (Object)new FacadeBlockId(mimicBlock.func_177230_c().getRegistryName().toString(), mimicBlock.func_177230_c().func_176201_c(mimicBlock)));
        }
        return extendedBlockState;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return GenericCableBakedModel.modelConnector;
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignoreState);
    }

    protected void clOnNeighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn) {
        this.checkRedstone(world, pos);
    }

    public void onNeighborChange(IBlockAccess blockAccess, BlockPos pos, BlockPos neighbor) {
        if (blockAccess instanceof World) {
            TileEntity te;
            World world = (World)blockAccess;
            if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof ConnectorTileEntity) {
                ConnectorTileEntity connector = (ConnectorTileEntity)te;
                connector.possiblyMarkNetworkDirty(neighbor);
            }
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    private void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ConnectorTileEntity) {
            int powered = world.func_175687_A(pos);
            ConnectorTileEntity genericTileEntity = (ConnectorTileEntity)te;
            genericTileEntity.setPowerInput(powered);
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof ConnectorBlock && te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connector = (ConnectorTileEntity)te;
            return connector.getPowerOut(side.func_176734_d());
        }
        return 0;
    }

    protected IBlockState clGetStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        world.func_175704_b(pos.func_177982_a(-1, -1, -1), pos.func_177982_a(1, 1, 1));
        return super.clGetStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    @Override
    protected ConnectorType getConnectorType(@Nonnull CableColor color, IBlockAccess world, BlockPos connectorPos, EnumFacing facing) {
        BlockPos pos = connectorPos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((block instanceof NetCableBlock || block instanceof ConnectorBlock) && state.func_177229_b((IProperty)COLOR) == color) {
            return ConnectorType.CABLE;
        }
        if (ConnectorBlock.isConnectable(world, connectorPos, facing) && color != CableColor.ROUTING) {
            return ConnectorType.BLOCK;
        }
        if (ConnectorBlock.isConnectableRouting(world, pos) && color == CableColor.ROUTING) {
            return ConnectorType.BLOCK;
        }
        return ConnectorType.NONE;
    }

    public static boolean isConnectableRouting(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        return te instanceof TileEntityRouter;
    }

    public static boolean isConnectable(IBlockAccess world, BlockPos connectorPos, EnumFacing facing) {
        ConnectorTileEntity connectorTE = (ConnectorTileEntity)world.func_175625_s(connectorPos);
        if (!connectorTE.isEnabled(facing)) {
            return false;
        }
        BlockPos pos = connectorPos.func_177972_a(facing);
        TileEntity te = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ConnectorBlock) {
            return false;
        }
        if (block == ModBlocks.redstoneProxyBlock || block == Blocks.field_150379_bu || block == Blocks.field_150374_bv) {
            return true;
        }
        if (block.canConnectRedstone(state, world, pos, null) || state.func_185897_m()) {
            return true;
        }
        if (te == null) {
            return false;
        }
        if (te instanceof IInventory) {
            return true;
        }
        if (EnergyTools.isEnergyTE((TileEntity)te)) {
            return true;
        }
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return true;
        }
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return true;
        }
        if (te instanceof TileEntityController) {
            return true;
        }
        return te instanceof TileEntityRouter;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState mimicBlock = this.getMimicBlock(blockAccess, pos);
        if (mimicBlock == null) {
            return false;
        }
        return mimicBlock.func_185894_c(blockAccess, pos, side);
    }

    public List<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(blockAccess, pos, state, fortune);
        if (blockAccess instanceof World) {
            World world = (World)blockAccess;
            for (ItemStack drop : drops) {
                WorldBlob worldBlob;
                ConsumerId consumer;
                if (!drop.func_77942_o()) {
                    drop.func_77982_d(new NBTTagCompound());
                }
                if ((consumer = (worldBlob = XNetBlobData.getBlobData(world).getWorldBlob(world)).getConsumerAt(pos)) == null) continue;
                drop.func_77978_p().func_74768_a("consumerId", consumer.getId());
            }
        }
        return drops;
    }

    public void clAddInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean adv) {
        super.clAddInformation(stack, player, tooltip, adv);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + "Place connector next to block or");
            tooltip.add(TextFormatting.BLUE + "machine that should be connected");
            tooltip.add(TextFormatting.BLUE + "to the network");
            boolean advanced = this == NetCableSetup.advancedConnectorBlock;
            int maxrf = advanced ? GeneralConfiguration.maxRfAdvancedConnector : GeneralConfiguration.maxRfConnector;
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.BOLD + "Max RF: " + TextFormatting.WHITE + maxrf);
            if (advanced) {
                tooltip.add(TextFormatting.GRAY + "Allow access to different sides");
                tooltip.add(TextFormatting.GRAY + "Supports faster item transfer");
            }
        } else {
            tooltip.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    public void createCableSegment(World world, BlockPos pos, ItemStack stack) {
        ConsumerId consumer;
        if (ItemStackTools.isValid((ItemStack)stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("consumerId")) {
            consumer = new ConsumerId(stack.func_77978_p().func_74762_e("consumerId"));
        } else {
            XNetBlobData blobData = XNetBlobData.getBlobData(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            consumer = worldBlob.newConsumer();
        }
        this.createCableSegment(world, pos, consumer);
    }

    public void createCableSegment(World world, BlockPos pos, ConsumerId consumer) {
        XNetBlobData blobData = XNetBlobData.getBlobData(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        CableColor color = (CableColor)((Object)world.func_180495_p(pos).func_177229_b((IProperty)COLOR));
        worldBlob.createNetworkConsumer(pos, new ColorId(color.ordinal() + 1), consumer);
        blobData.save(world);
    }

    @Override
    public boolean isAdvancedConnector() {
        return false;
    }
}

