/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.varia.WorldTools;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.DefaultChannelSettings;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.apiimpl.logic.LogicConnectorSettings;
import mcjty.xnet.apiimpl.logic.Sensor;
import mcjty.xnet.blocks.cables.ConnectorTileEntity;
import mcjty.xnet.blocks.controller.gui.GuiController;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class LogicChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    private int delay = 0;
    private int colors = 0;
    private List<Pair<SidedConsumer, LogicConnectorSettings>> sensors = null;
    private List<Pair<SidedConsumer, LogicConnectorSettings>> outputs = null;

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.delay = tag.func_74762_e("delay");
        this.colors = tag.func_74762_e("colors");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("colors", this.colors);
    }

    @Override
    public int getColors() {
        return this.colors;
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        LogicConnectorSettings settings;
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 5 != 0) {
            return;
        }
        int d = this.delay / 5;
        this.updateCache(channel, context);
        World world = context.getControllerWorld();
        this.colors = 0;
        for (Pair<SidedConsumer, LogicConnectorSettings> entry : this.sensors) {
            settings = (LogicConnectorSettings)entry.getValue();
            if (d % settings.getSpeed() != 0) {
                this.colors |= settings.getColorMask();
                continue;
            }
            int sensorColors = 0;
            BlockPos connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            if (connectorPos != null) {
                EnumFacing side = ((SidedConsumer)entry.getKey()).getSide();
                BlockPos pos = connectorPos.func_177972_a(side);
                if (!WorldTools.chunkLoaded((World)world, (BlockPos)pos)) {
                    this.colors |= settings.getColorMask();
                    continue;
                }
                boolean sense = true;
                boolean bl = sense = !this.checkRedstone(world, settings, connectorPos);
                if (sense && !context.matchColor(settings.getColorsMask())) {
                    sense = false;
                }
                if (sense) {
                    TileEntity te = world.func_175625_s(pos);
                    for (Sensor sensor : settings.getSensors()) {
                        if (!sensor.test(te, world, pos, settings)) continue;
                        sensorColors |= 1 << sensor.getOutputColor().ordinal();
                    }
                }
            }
            settings.setColorMask(sensorColors);
            this.colors |= sensorColors;
        }
        for (Pair<SidedConsumer, LogicConnectorSettings> entry : this.outputs) {
            TileEntity te;
            BlockPos connectorPos;
            settings = (LogicConnectorSettings)entry.getValue();
            if (d % settings.getSpeed() != 0 || (connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId())) == null) continue;
            EnumFacing side = ((SidedConsumer)entry.getKey()).getSide();
            if (!WorldTools.chunkLoaded((World)world, (BlockPos)connectorPos) || !((te = world.func_175625_s(connectorPos)) instanceof ConnectorTileEntity)) continue;
            ConnectorTileEntity connectorTE = (ConnectorTileEntity)te;
            int powerOut = this.checkRedstone(world, settings, connectorPos) ? 0 : (!context.matchColor(settings.getColorsMask()) ? 0 : (settings.getRedstoneOut() == null ? 0 : settings.getRedstoneOut()));
            connectorTE.setPowerOut(side, powerOut);
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.sensors == null) {
            LogicConnectorSettings con;
            this.sensors = new ArrayList<Pair<SidedConsumer, LogicConnectorSettings>>();
            this.outputs = new ArrayList<Pair<SidedConsumer, LogicConnectorSettings>>();
            Map<SidedConsumer, IConnectorSettings> connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (LogicConnectorSettings)entry.getValue();
                if (con.getLogicMode() == LogicConnectorSettings.LogicMode.SENSOR) {
                    this.sensors.add((Pair<SidedConsumer, LogicConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
                    continue;
                }
                this.outputs.add((Pair<SidedConsumer, LogicConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (LogicConnectorSettings)entry.getValue();
                if (con.getLogicMode() != LogicConnectorSettings.LogicMode.OUTPUT) continue;
                this.outputs.add((Pair<SidedConsumer, LogicConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
        }
    }

    @Override
    public void cleanCache() {
        this.sensors = null;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(GuiController.iconGuiElements, 11, 90, 11, 10);
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public boolean isEnabled(String tag) {
        return true;
    }

    @Override
    public void createGui(IEditorGui gui) {
    }

    @Override
    public void update(Map<String, Object> data) {
    }
}

