/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.MinecraftTools;
import mcjty.xnet.XNet;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.cables.ConnectorType;
import mcjty.xnet.blocks.facade.FacadeBlock;
import mcjty.xnet.blocks.facade.FacadeBlockId;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.generic.GenericCableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWorldLastEventHandler {
    private static long lastTime = 0L;

    public static void tick(RenderWorldLastEvent evt) {
        RenderWorldLastEventHandler.renderHilightedBlock(evt);
        RenderWorldLastEventHandler.renderCables(evt);
    }

    private static void renderCables(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP p = MinecraftTools.getPlayer((Minecraft)mc);
        ItemStack heldItem = p.func_184586_b(EnumHand.MAIN_HAND);
        if (ItemStackTools.isValid((ItemStack)heldItem) && heldItem.func_77973_b() instanceof ItemBlock && ((ItemBlock)heldItem.func_77973_b()).func_179223_d() instanceof GenericCableBlock) {
            RenderWorldLastEventHandler.renderCablesInt(evt, mc);
        }
    }

    private static void renderCablesInt(RenderWorldLastEvent evt, Minecraft mc) {
        EntityPlayerSP p = MinecraftTools.getPlayer((Minecraft)mc);
        WorldClient world = MinecraftTools.getWorld((Minecraft)mc);
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (int dx = -20; dx <= 20; ++dx) {
            for (int dy = -20; dy <= 20; ++dy) {
                for (int dz = -20; dz <= 20; ++dz) {
                    IExtendedBlockState extendedBlockState;
                    FacadeBlockId facadeId;
                    BlockPos c = p.func_180425_c().func_177982_a(dx, dy, dz);
                    IBlockState state = world.func_180495_p(c);
                    Block block = state.func_177230_c();
                    if (!(block instanceof FacadeBlock) && !(block instanceof ConnectorBlock) || (facadeId = (FacadeBlockId)(extendedBlockState = state.func_177230_c() instanceof FacadeBlock ? (IExtendedBlockState)((FacadeBlock)state.func_177230_c()).getStateInternal(state, (IBlockAccess)world, c) : (IExtendedBlockState)state.func_177230_c().getExtendedState(state, (IBlockAccess)world, c)).getValue((IUnlistedProperty)GenericCableBlock.FACADEID)) == null && !(block instanceof FacadeBlock)) continue;
                    CableColor color = (CableColor)((Object)extendedBlockState.func_177229_b(GenericCableBlock.COLOR));
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    switch (color) {
                        case BLUE: {
                            r = 0.4f;
                            g = 0.4f;
                            b = 1.0f;
                            break;
                        }
                        case RED: {
                            r = 1.0f;
                            g = 0.4f;
                            b = 0.4f;
                            break;
                        }
                        case YELLOW: {
                            r = 1.0f;
                            g = 1.0f;
                            b = 0.4f;
                            break;
                        }
                        case GREEN: {
                            r = 0.4f;
                            g = 1.0f;
                            b = 0.4f;
                            break;
                        }
                        case ROUTING: {
                            r = 0.7f;
                            g = 0.7f;
                            b = 0.7f;
                        }
                    }
                    List<Rect> quads = RenderWorldLastEventHandler.getQuads(extendedBlockState);
                    for (Rect quad : quads) {
                        RenderWorldLastEventHandler.renderRect(buffer, quad, c, r, g, b, 0.5f);
                    }
                }
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static Vec3d v(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }

    private static List<Rect> getQuads(IExtendedBlockState extendedBlockState) {
        ConnectorType north = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.NORTH));
        ConnectorType south = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.SOUTH));
        ConnectorType west = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.WEST));
        ConnectorType east = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.EAST));
        ConnectorType up = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.UP));
        ConnectorType down = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.DOWN));
        ArrayList<Rect> quads = new ArrayList<Rect>();
        double o = 0.4;
        double p = 0.1;
        double q = 0.2;
        if (up == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, 1.0, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0, 1.0 - o)));
        } else if (up == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, 1.0 - p, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - p, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - p, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - p, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - p, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - p, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - p, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - p, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - p, 1.0 - q), RenderWorldLastEventHandler.v(q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(q, 1.0, q), RenderWorldLastEventHandler.v(q, 1.0 - p, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, q), RenderWorldLastEventHandler.v(q, 1.0 - p, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(q, 1.0, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - p, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, q), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - p, 1.0 - q), RenderWorldLastEventHandler.v(q, 1.0 - p, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0, q), RenderWorldLastEventHandler.v(q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 1.0, q)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o)));
        }
        if (down == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 0.0, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 0.0, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, 0.0, o), RenderWorldLastEventHandler.v(o, 0.0, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, 0.0, o), RenderWorldLastEventHandler.v(o, 0.0, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 0.0, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 0.0, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
        } else if (down == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, p, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, p, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, p, o), RenderWorldLastEventHandler.v(o, p, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, p, o), RenderWorldLastEventHandler.v(o, p, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, p, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, p, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - q, 0.0, q), RenderWorldLastEventHandler.v(1.0 - q, p, q), RenderWorldLastEventHandler.v(1.0 - q, p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 0.0, 1.0 - q), RenderWorldLastEventHandler.v(q, p, 1.0 - q), RenderWorldLastEventHandler.v(q, p, q), RenderWorldLastEventHandler.v(q, 0.0, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, p, q), RenderWorldLastEventHandler.v(1.0 - q, p, q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, q), RenderWorldLastEventHandler.v(q, 0.0, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 0.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, p, 1.0 - q), RenderWorldLastEventHandler.v(q, p, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, p, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - q, p, q), RenderWorldLastEventHandler.v(q, p, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 0.0, 1.0 - q), RenderWorldLastEventHandler.v(q, 0.0, q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, q), RenderWorldLastEventHandler.v(1.0 - q, 0.0, 1.0 - q)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
        }
        if (east == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, o, o), RenderWorldLastEventHandler.v(1.0, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o)));
        } else if (east == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, o, o), RenderWorldLastEventHandler.v(1.0 - p, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - p, o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, q, q), RenderWorldLastEventHandler.v(1.0, q, q), RenderWorldLastEventHandler.v(1.0, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - p, q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0, q, q), RenderWorldLastEventHandler.v(1.0 - p, q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - p, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(1.0 - p, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0 - p, q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0, q, 1.0 - q), RenderWorldLastEventHandler.v(1.0, q, q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, q), RenderWorldLastEventHandler.v(1.0, 1.0 - q, 1.0 - q)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o)));
        }
        if (west == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(0.0, 1.0 - o, o), RenderWorldLastEventHandler.v(0.0, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(0.0, o, 1.0 - o), RenderWorldLastEventHandler.v(0.0, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(0.0, o, o), RenderWorldLastEventHandler.v(0.0, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(0.0, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(0.0, o, 1.0 - o)));
        } else if (west == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(p, 1.0 - o, o), RenderWorldLastEventHandler.v(p, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(p, o, 1.0 - o), RenderWorldLastEventHandler.v(p, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(p, o, o), RenderWorldLastEventHandler.v(p, 1.0 - o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(p, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(p, o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(p, 1.0 - q, q), RenderWorldLastEventHandler.v(0.0, 1.0 - q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, q, q), RenderWorldLastEventHandler.v(p, q, q), RenderWorldLastEventHandler.v(p, q, 1.0 - q), RenderWorldLastEventHandler.v(0.0, q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, 1.0 - q, q), RenderWorldLastEventHandler.v(p, 1.0 - q, q), RenderWorldLastEventHandler.v(p, q, q), RenderWorldLastEventHandler.v(0.0, q, q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, q, 1.0 - q), RenderWorldLastEventHandler.v(p, q, 1.0 - q), RenderWorldLastEventHandler.v(p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(0.0, 1.0 - q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(p, q, q), RenderWorldLastEventHandler.v(p, 1.0 - q, q), RenderWorldLastEventHandler.v(p, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(p, q, 1.0 - q)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(0.0, q, q), RenderWorldLastEventHandler.v(0.0, q, 1.0 - q), RenderWorldLastEventHandler.v(0.0, 1.0 - q, 1.0 - q), RenderWorldLastEventHandler.v(0.0, 1.0 - q, q)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, o, o)));
        }
        if (north == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 0.0), RenderWorldLastEventHandler.v(o, 1.0 - o, 0.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 0.0), RenderWorldLastEventHandler.v(1.0 - o, o, 0.0), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, 0.0), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 0.0), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, 0.0), RenderWorldLastEventHandler.v(o, o, 0.0)));
        } else if (north == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, p), RenderWorldLastEventHandler.v(o, 1.0 - o, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, p), RenderWorldLastEventHandler.v(1.0 - o, o, p), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, p), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, p), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(o, 1.0 - o, p), RenderWorldLastEventHandler.v(o, o, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - q, p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(q, 1.0 - q, 0.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, q, p), RenderWorldLastEventHandler.v(q, q, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - q, q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, p), RenderWorldLastEventHandler.v(1.0 - q, q, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, p), RenderWorldLastEventHandler.v(q, 1.0 - q, p), RenderWorldLastEventHandler.v(q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(q, q, 0.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, p), RenderWorldLastEventHandler.v(1.0 - q, q, p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, p), RenderWorldLastEventHandler.v(q, 1.0 - q, p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, 0.0), RenderWorldLastEventHandler.v(q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 0.0), RenderWorldLastEventHandler.v(1.0 - q, q, 0.0)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, o), RenderWorldLastEventHandler.v(1.0 - o, o, o), RenderWorldLastEventHandler.v(o, o, o)));
        }
        if (south == ConnectorType.CABLE) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0), RenderWorldLastEventHandler.v(o, o, 1.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
        } else if (south == ConnectorType.BLOCK) {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - p), RenderWorldLastEventHandler.v(o, o, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - p), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - p), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, o, 1.0 - o)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0), RenderWorldLastEventHandler.v(q, q, 1.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(1.0 - q, q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, q, 1.0), RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(q, q, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0 - p), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0 - p), RenderWorldLastEventHandler.v(q, q, 1.0 - p)));
            quads.add(new Rect(RenderWorldLastEventHandler.v(q, 1.0 - q, 1.0), RenderWorldLastEventHandler.v(q, q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, q, 1.0), RenderWorldLastEventHandler.v(1.0 - q, 1.0 - q, 1.0)));
        } else {
            quads.add(new Rect(RenderWorldLastEventHandler.v(o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, o, 1.0 - o), RenderWorldLastEventHandler.v(1.0 - o, 1.0 - o, 1.0 - o), RenderWorldLastEventHandler.v(o, 1.0 - o, 1.0 - o)));
        }
        return quads;
    }

    public static void renderRect(VertexBuffer buffer, Rect rect, BlockPos p, float r, float g, float b, float a) {
        buffer.func_181662_b((double)p.func_177958_n() + rect.v1.field_72450_a, (double)p.func_177956_o() + rect.v1.field_72448_b, (double)p.func_177952_p() + rect.v1.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)p.func_177958_n() + rect.v2.field_72450_a, (double)p.func_177956_o() + rect.v2.field_72448_b, (double)p.func_177952_p() + rect.v2.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)p.func_177958_n() + rect.v2.field_72450_a, (double)p.func_177956_o() + rect.v2.field_72448_b, (double)p.func_177952_p() + rect.v2.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)p.func_177958_n() + rect.v3.field_72450_a, (double)p.func_177956_o() + rect.v3.field_72448_b, (double)p.func_177952_p() + rect.v3.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)p.func_177958_n() + rect.v3.field_72450_a, (double)p.func_177956_o() + rect.v3.field_72448_b, (double)p.func_177952_p() + rect.v3.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)p.func_177958_n() + rect.v4.field_72450_a, (double)p.func_177956_o() + rect.v4.field_72448_b, (double)p.func_177952_p() + rect.v4.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)p.func_177958_n() + rect.v4.field_72450_a, (double)p.func_177956_o() + rect.v4.field_72448_b, (double)p.func_177952_p() + rect.v4.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)p.func_177958_n() + rect.v1.field_72450_a, (double)p.func_177956_o() + rect.v1.field_72448_b, (double)p.func_177952_p() + rect.v1.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
    }

    private static void renderHilightedBlock(RenderWorldLastEvent evt) {
        BlockPos c = XNet.instance.clientInfo.getHilightedBlock();
        if (c == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.currentTimeMillis();
        if (time > XNet.instance.clientInfo.getExpireHilight()) {
            XNet.instance.clientInfo.hilightBlock(null, -1L);
            return;
        }
        if ((time / 500L & 1L) == 0L) {
            return;
        }
        EntityPlayerSP p = MinecraftTools.getPlayer((Minecraft)mc);
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        float mx = c.func_177958_n();
        float my = c.func_177956_o();
        float mz = c.func_177952_p();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        RenderHelper.renderHighLightedBlocksOutline((VertexBuffer)buffer, (float)mx, (float)my, (float)mz, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static class Rect {
        public Vec3d v1;
        public Vec3d v2;
        public Vec3d v3;
        public Vec3d v4;

        public Rect(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.v4 = v4;
        }
    }
}

