/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.util.helpers;

import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IBackpack;
import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IUpgradableBackpack;
import gr8pefish.ironbackpacks.api.register.ItemIUpgradeRegistry;
import gr8pefish.ironbackpacks.capabilities.player.PlayerDeathBackpackCapabilities;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.network.NetworkingHandler;
import gr8pefish.ironbackpacks.network.client.ClientEquippedPackMessage;
import gr8pefish.ironbackpacks.network.client.ClientEquippedPackPlayerSensitiveMessage;
import gr8pefish.ironbackpacks.registry.ItemRegistry;
import gr8pefish.ironbackpacks.util.NBTUtils;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class IronBackpacksHelper {
    public static ItemStack getBackpack(EntityPlayer player) {
        ItemStack currPack = PlayerWearingBackpackCapabilities.getCurrentBackpack((EntityLivingBase)player);
        ItemStack backpack = currPack != null ? currPack : (PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player) != null ? PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player) : IronBackpacksHelper.getBackpackFromPlayersInventory(player));
        if (!player.field_70170_p.field_72995_K && backpack != null) {
            NBTUtils.setUUID(backpack);
        }
        return backpack;
    }

    public static ItemStack getBackpackFromPlayersInventory(EntityPlayer player) {
        ItemStack backpack = null;
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof IBackpack) {
            backpack = player.func_184614_ca();
        } else {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IBackpack)) continue;
                backpack = player.field_71071_by.func_70301_a(i);
            }
        }
        if (!player.field_70170_p.field_72995_K && backpack != null) {
            NBTUtils.setUUID(backpack);
        }
        return backpack;
    }

    public static ArrayList<ItemStack> getUpgradesAppliedFromNBT(ItemStack backpack) {
        NBTTagCompound nbtTagCompound;
        ArrayList<ItemStack> upgradesArrayList = new ArrayList<ItemStack>();
        if (backpack != null && (nbtTagCompound = backpack.func_77978_p()) != null && nbtTagCompound.func_74764_b("Upgrades")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Upgrades", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                ItemStack upgrade = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                if (upgrade == null) continue;
                upgradesArrayList.add(upgrade);
            }
        }
        return upgradesArrayList;
    }

    public static int getUpgradePointsUsed(ArrayList<ItemStack> upgrades) {
        int counter = 0;
        for (ItemStack stack : upgrades) {
            counter += ItemIUpgradeRegistry.getItemUpgrade(stack).getUpgradeCost(stack);
        }
        return counter;
    }

    public static int getTotalUpgradePointsFromNBT(ItemStack stack) {
        IUpgradableBackpack backpack = (IUpgradableBackpack)stack.func_77973_b();
        int upgradeCount = backpack.getUpgradePoints(stack);
        int extraPoints = IronBackpacksHelper.getAdditionalUpgradesUpgradeCount(stack);
        return upgradeCount + extraPoints;
    }

    public static int getAdditionalUpgradesUpgradeCount(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("AdditionalPoints")) {
            return nbtTagCompound.func_74759_k("AdditionalPoints")[0];
        }
        return 0;
    }

    public static int getAdditionalUpgradesTimesApplied(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("AdditionalPoints")) {
            return nbtTagCompound.func_74759_k("AdditionalPoints")[1];
        }
        return 0;
    }

    public static void equipBackpackFromKeybinding(EntityPlayer player) {
        ItemStack backpack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
        if (backpack != null) {
            int i;
            boolean hasEmptyHotbarSlot = false;
            boolean hasEmptyOffhand = false;
            boolean hasEmptyInventorySlot = false;
            for (i = 0; i < 9; ++i) {
                if (player.field_71071_by.func_70301_a(i) != null) continue;
                hasEmptyHotbarSlot = true;
            }
            if (hasEmptyHotbarSlot) {
                if (player.func_184614_ca() == null) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, backpack);
                } else {
                    player.field_71071_by.func_70441_a(backpack);
                }
            } else {
                if (player.func_184592_cb() == null) {
                    hasEmptyOffhand = true;
                }
                if (hasEmptyOffhand) {
                    ItemStack selected = player.func_184586_b(EnumHand.MAIN_HAND);
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, selected);
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, backpack);
                } else {
                    for (i = 9; i < player.field_71071_by.func_70302_i_() - 5; ++i) {
                        if (player.field_71071_by.func_70301_a(i) != null) continue;
                        hasEmptyInventorySlot = true;
                    }
                    if (hasEmptyInventorySlot) {
                        ItemStack selected = player.func_184586_b(EnumHand.MAIN_HAND).func_77946_l();
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, backpack);
                        player.field_71071_by.func_70441_a(selected);
                    }
                }
            }
            if (hasEmptyHotbarSlot || hasEmptyOffhand || hasEmptyInventorySlot) {
                PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, null);
                NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(null), (EntityPlayerMP)player);
                EntityTracker tracker = ((EntityPlayerMP)player).field_70170_p.func_73046_m().func_71218_a(player.field_71093_bK).func_73039_n();
                tracker.func_151247_a((Entity)player, NetworkingHandler.network.getPacketFrom((IMessage)new ClientEquippedPackPlayerSensitiveMessage(player.func_145782_y(), null)));
            }
        } else if (!ConfigHandler.disableEquipping && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof IBackpack) {
            ItemStack backpackStack = player.func_184614_ca();
            NBTUtils.setUUID(backpackStack);
            PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, backpackStack);
            NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(backpackStack), (EntityPlayerMP)player);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            EntityTracker tracker = ((EntityPlayerMP)player).field_70170_p.func_73046_m().func_71218_a(player.field_71093_bK).func_73039_n();
            tracker.func_151247_a((Entity)player, NetworkingHandler.network.getPacketFrom((IMessage)new ClientEquippedPackPlayerSensitiveMessage(player.func_145782_y(), backpackStack)));
        }
    }

    public static EntityItem savePlayerDeathDrops(EntityPlayer player) {
        ItemStack deathEquipped;
        EntityItem entityItem = null;
        boolean gameruleKeepInv = player.field_70170_p.func_82736_K().func_82766_b("keepInventory");
        ArrayList backpacks = new ArrayList();
        boolean shouldStorePack = false;
        boolean stored = false;
        Object packToStore = null;
        ItemStack equippedPack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
        if (!(equippedPack == null || UpgradeMethods.hasEternityUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(equippedPack)) || gameruleKeepInv || (deathEquipped = PlayerDeathBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player)) != null && deathEquipped.equals(equippedPack))) {
            entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, equippedPack);
            PlayerDeathBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, null);
        }
        return entityItem;
    }

    public static void saveEternityBackpacksOnDeath(EntityPlayer player) {
        ArrayList<ItemStack> backpacks = new ArrayList<ItemStack>();
        boolean gameruleKeepInv = player.field_70170_p.func_82736_K().func_82766_b("keepInventory");
        ItemStack equippedPack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
        if (equippedPack != null) {
            if (UpgradeMethods.hasEternityUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(equippedPack))) {
                if (gameruleKeepInv) {
                    PlayerDeathBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, equippedPack.func_77946_l());
                } else {
                    ItemStack updatedEquippedPack = IronBackpacksHelper.removeEternityUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(equippedPack), equippedPack);
                    PlayerDeathBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, updatedEquippedPack);
                }
            } else if (gameruleKeepInv) {
                PlayerDeathBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, equippedPack.func_77946_l());
            }
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack tempStack = player.field_71071_by.func_70301_a(i);
            if (tempStack == null || !(tempStack.func_77973_b() instanceof IBackpack) || !UpgradeMethods.hasEternityUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(tempStack)) || gameruleKeepInv) continue;
            ItemStack stackToAdd = IronBackpacksHelper.removeEternityUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(tempStack), tempStack);
            backpacks.add(stackToAdd);
            player.field_71071_by.func_70299_a(i, null);
        }
        PlayerDeathBackpackCapabilities.setEternityBackpacks((EntityLivingBase)player, backpacks);
    }

    public static void loadBackpackOnDeath(EntityPlayer player) {
        ArrayList<ItemStack> packs;
        ItemStack equipped = PlayerDeathBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
        if (equipped != null) {
            NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(equipped), (EntityPlayerMP)player);
            PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, equipped);
        }
        if ((packs = PlayerDeathBackpackCapabilities.getEternityBackpacks((EntityLivingBase)player)) != null && !packs.isEmpty()) {
            for (ItemStack stack : packs) {
                boolean added = player.field_71071_by.func_70441_a(stack);
                if (added) continue;
                player.func_71019_a(stack, false);
            }
        }
        PlayerDeathBackpackCapabilities.reset((EntityLivingBase)player);
    }

    private static ItemStack removeEternityUpgrade(ArrayList<ItemStack> upgrades, ItemStack stack) {
        if (stack != null) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            NBTTagList tagList = new NBTTagList();
            for (ItemStack upgrade : upgrades) {
                if (ItemIUpgradeRegistry.isInstanceOfIUpgrade(upgrade) && ItemIUpgradeRegistry.getItemIUpgrade(upgrade.func_77952_i()).equals(ItemRegistry.eternityUpgrade)) continue;
                tagList.func_74742_a((NBTBase)upgrade.func_77955_b(new NBTTagCompound()));
            }
            nbtTagCompound.func_74782_a("Upgrades", (NBTBase)tagList);
            return stack;
        }
        return null;
    }

    public static boolean areItemStacksTheSame(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStack.func_77989_b((ItemStack)itemStack1, (ItemStack)itemStack2) && ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2);
    }

    public static boolean areItemsEqualForStacking(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1.func_77973_b().equals(itemStack2.func_77973_b()) && ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2) && (itemStack1.func_77952_i() == Short.MAX_VALUE || itemStack2.func_77952_i() == Short.MAX_VALUE || itemStack1.func_77952_i() == itemStack2.func_77952_i());
    }

    public static boolean areItemsEqualAndStackable(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1.func_77985_e() && itemStack1.field_77994_a < itemStack1.func_77976_d() && IronBackpacksHelper.areItemsEqualForStacking(itemStack1, itemStack2);
    }
}

