/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.proxies;

import gr8pefish.ironbackpacks.client.ClientEventHandler;
import gr8pefish.ironbackpacks.client.KeyHandler;
import gr8pefish.ironbackpacks.client.renderer.LayerBackpack;
import gr8pefish.ironbackpacks.config.ConfigAdaptor;
import gr8pefish.ironbackpacks.proxies.CommonProxy;
import gr8pefish.ironbackpacks.registry.ProxyRegistry;
import gr8pefish.ironbackpacks.util.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        KeyHandler.init();
        this.initClientEventHandlers();
        ProxyRegistry.preInitClient();
    }

    @Override
    public void init() {
        this.addBackpackModelLayer();
        ProxyRegistry.initClient();
    }

    @Override
    public void postInit() {
        ProxyRegistry.postInitClient();
    }

    private void initClientEventHandlers() {
        FMLCommonHandler.instance().bus().register((Object)new ClientEventHandler());
    }

    @Override
    public String getModVersion() {
        return "1.10.2-2.2.31";
    }

    @Override
    public String getRemoteUpdatedVersion() {
        return ConfigAdaptor.getLatestFilenameFromCurse("https://raw.githubusercontent.com/gr8pefish/IronBackpacks/master-1.10/version/1.10.2");
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private void addBackpackModelLayer() {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        try {
            RenderPlayer renderPlayer = (RenderPlayer)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)renderManager, (String[])new String[]{"playerRenderer", "field_178637_m"});
            renderPlayer.func_177094_a((LayerRenderer)new LayerBackpack(renderPlayer));
            Logger.info("Added Layer Backpack");
        }
        catch (Exception e) {
            Logger.error("Failed to add Layer Backpack!");
            Logger.error(e.getLocalizedMessage());
        }
    }
}

