/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.events;

import gr8pefish.ironbackpacks.capabilities.IronBackpacksCapabilities;
import gr8pefish.ironbackpacks.capabilities.player.PlayerDeathBackpackCapabilities;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.events.IronBackpacksEventHelper;
import gr8pefish.ironbackpacks.integration.InterModSupport;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.network.NetworkingHandler;
import gr8pefish.ironbackpacks.network.client.ClientEquippedPackMessage;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ForgeEventHandler {
    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            if (!event.getEntity().hasCapability(IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY, null)) {
                event.addCapability(new ResourceLocation("ironbackpacks.WEARING_BACKPACK_CAP"), (ICapabilityProvider)new PlayerWearingBackpackCapabilities());
            }
            if (!event.getEntity().hasCapability(IronBackpacksCapabilities.DEATH_BACKPACK_CAPABILITY, null)) {
                event.addCapability(new ResourceLocation("ironbackpacks.DEATH_BACKPACK_CAP"), (ICapabilityProvider)new PlayerDeathBackpackCapabilities());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloning(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            if (event.getOriginal().hasCapability(IronBackpacksCapabilities.DEATH_BACKPACK_CAPABILITY, null)) {
                PlayerDeathBackpackCapabilities oldCap = (PlayerDeathBackpackCapabilities)event.getOriginal().getCapability(IronBackpacksCapabilities.DEATH_BACKPACK_CAPABILITY, null);
                PlayerDeathBackpackCapabilities newCap = (PlayerDeathBackpackCapabilities)event.getEntityPlayer().getCapability(IronBackpacksCapabilities.DEATH_BACKPACK_CAPABILITY, null);
                newCap.setEternityBackpacks(oldCap.getEternityBackpacks());
                newCap.setEquippedBackpack(oldCap.getEquippedBackpack());
            }
        } else if (event.getOriginal().hasCapability(IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY, null)) {
            PlayerWearingBackpackCapabilities oldCap = (PlayerWearingBackpackCapabilities)event.getOriginal().getCapability(IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY, null);
            PlayerWearingBackpackCapabilities newCap = (PlayerWearingBackpackCapabilities)event.getEntityPlayer().getCapability(IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY, null);
            newCap.setCurrentBackpack(oldCap.getCurrentBackpack());
            newCap.setEquippedBackpack(oldCap.getEquippedBackpack());
        }
    }

    @SubscribeEvent
    public void onPlayerDrops(PlayerDropsEvent event) {
        EntityItem drop;
        if (!event.getEntity().field_70170_p.field_72995_K && (drop = IronBackpacksHelper.savePlayerDeathDrops(event.getEntityPlayer())) != null) {
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onDeath(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            IronBackpacksHelper.saveEternityBackpacksOnDeath((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            IronBackpacksHelper.loadBackpackOnDeath((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        ItemStack backpack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)event.player);
        if (backpack != null) {
            NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(backpack), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ItemStack backpack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)event.player);
        if (backpack != null) {
            NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(backpack), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerDimChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        ItemStack backpack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)event.player);
        if (backpack != null) {
            NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(backpack), (EntityPlayerMP)event.player);
        } else {
            NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(null), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onItemPickupEvent(EntityItemPickupEvent event) {
        if (!event.isCanceled()) {
            ArrayList<ArrayList<ItemStack>> backpacks = IronBackpacksEventHelper.getFilterCrafterAndRestockerBackpacks(event.getEntityPlayer());
            IronBackpacksEventHelper.checkFilterUpgrade(event, backpacks.get(0));
            for (int i = 1; i < 4; ++i) {
                IronBackpacksEventHelper.checkCrafterUpgrade(event, backpacks.get(i), i);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerItemUseEvent(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled()) {
            ForgeEventHandler.doRestock(event.getEntityPlayer(), event.getItemStack());
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!event.isCanceled()) {
            ItemStack itemStack = null;
            ArrayList<ArrayList<ItemStack>> backpacks = null;
            RayTraceResult rayTraceResult = event.getWorld().func_72933_a(event.getEntityPlayer().func_174791_d(), event.getEntityPlayer().func_70040_Z());
            if (rayTraceResult == null) {
                return;
            }
            itemStack = event.getWorld().func_180495_p(event.getPos()).func_177230_c().getPickBlock(event.getWorld().func_180495_p(event.getPos()), rayTraceResult, event.getWorld(), event.getPos(), event.getEntityPlayer());
            backpacks = IronBackpacksEventHelper.getFilterCrafterAndRestockerBackpacks(event.getEntityPlayer());
            if (event.getEntityPlayer().func_184586_b(event.getHand()) != null && itemStack != null && backpacks != null && !backpacks.get(4).isEmpty() && !IronBackpacksHelper.areItemsEqualForStacking(event.getEntityPlayer().func_184586_b(event.getHand()), itemStack)) {
                ForgeEventHandler.doRestock(event.getEntityPlayer(), event.getItemStack());
            }
        }
    }

    private static void doRestock(EntityPlayer player, ItemStack stack) {
        ItemStack resuppliedStack;
        ArrayList<ArrayList<ItemStack>> backpacks = IronBackpacksEventHelper.getFilterCrafterAndRestockerBackpacks(player);
        if (player != null && stack != null && (resuppliedStack = IronBackpacksEventHelper.checkRestockerUpgradeItemUse(player, stack, backpacks.get(4))) != null) {
            stack.field_77994_a = resuppliedStack.field_77994_a;
        }
    }

    @SubscribeEvent
    public void onBlockPlacedEvent(BlockEvent.PlaceEvent event) {
        if (!event.isCanceled()) {
            if (event.getItemInHand() != null && InterModSupport.isExtraUtilsLoaded && InterModSupport.isExUtilsBuildersWand(event.getItemInHand().func_77973_b())) {
                return;
            }
            ArrayList<ArrayList<ItemStack>> backpacks = IronBackpacksEventHelper.getFilterCrafterAndRestockerBackpacks(event.getPlayer());
            RayTraceResult rayTraceResult = event.getWorld().func_72933_a(event.getPlayer().func_174791_d(), event.getPlayer().func_70040_Z());
            ItemStack itemStackPlaced = event.getPlacedBlock().func_177230_c().getPickBlock(event.getPlacedBlock(), rayTraceResult, event.getWorld(), event.getPos(), event.getPlayer());
            if (event.getItemInHand() != null && itemStackPlaced != null && !backpacks.get(4).isEmpty()) {
                if (!IronBackpacksHelper.areItemsEqualForStacking(event.getItemInHand(), itemStackPlaced)) {
                    IronBackpacksEventHelper.handleIndirectRestock(event.getPlayer(), backpacks.get(4), itemStackPlaced);
                } else {
                    IronBackpacksEventHelper.handleDirectRestock(event.getPlayer(), backpacks.get(4), event.getItemInHand(), true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onArrowLoose(ArrowLooseEvent event) {
        if (!event.isCanceled()) {
            ArrayList<ArrayList<ItemStack>> backpacks = IronBackpacksEventHelper.getFilterCrafterAndRestockerBackpacks(event.getEntityPlayer());
            ImmutablePair<ItemStack, Slot> pair = IronBackpacksEventHelper.checkRestockerUpgradeArrowLoose(event.getEntityPlayer(), backpacks.get(4));
            if (pair != null) {
                event.getEntityPlayer().field_71071_by.func_70299_a(((Slot)pair.getRight()).getSlotIndex(), (ItemStack)pair.getLeft());
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft().func_77973_b() instanceof ItemBackpack || event.getRight().func_77973_b() instanceof ItemBackpack) {
            event.setOutput(null);
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ironbackpacks")) {
            ConfigHandler.syncConfig(false);
        }
    }

    @SubscribeEvent
    public void onTrack(PlayerEvent.StartTracking event) {
        EntityPlayer targetPlayer;
        EntityPlayer tracker = event.getEntityPlayer();
        Entity targetEntity = event.getTarget();
        if (targetEntity instanceof EntityPlayerMP && (targetPlayer = (EntityPlayer)targetEntity).hasCapability(IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY, null)) {
            ItemStack backpack = IronBackpacksCapabilities.getWornBackpack(targetPlayer);
            if (backpack != null) {
                NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(backpack), (EntityPlayerMP)tracker);
            } else {
                NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(backpack), (EntityPlayerMP)tracker);
            }
        }
    }
}

