/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.crafting;

import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IUpgradableBackpack;
import gr8pefish.ironbackpacks.api.recipes.IRemoveUpgradeRecipe;
import gr8pefish.ironbackpacks.api.register.ItemIUpgradeRegistry;
import gr8pefish.ironbackpacks.container.backpack.InventoryBackpack;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.registry.ItemRegistry;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BackpackRemoveUpgradeRecipe
extends ShapelessOreRecipe
implements IRemoveUpgradeRecipe {
    private ItemStack recipeOutput;
    private ItemStack upgradeRemovedStack;

    public BackpackRemoveUpgradeRecipe(ItemStack recipeOutput, Object ... items) {
        super(recipeOutput, items);
        this.recipeOutput = recipeOutput;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        int slotOfBackpack = this.getFirstUpgradableBackpackSlotNumber(inventoryCrafting);
        if (slotOfBackpack == -1) {
            return null;
        }
        ItemStack backpack = inventoryCrafting.func_70301_a(slotOfBackpack);
        ItemStack result = backpack.func_77946_l();
        ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(result);
        if (upgrades.isEmpty()) {
            return null;
        }
        NBTTagCompound nbtTagCompound = result.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
            result.func_77982_d(nbtTagCompound);
        }
        boolean nullChecksPassed = false;
        ItemStack upgradeInQuestion = null;
        if (slotOfBackpack <= upgrades.size() - 1 && slotOfBackpack >= 0 && upgrades.get(slotOfBackpack) != null) {
            upgradeInQuestion = upgrades.get(slotOfBackpack);
            if (!this.canRemoveNestingUpgrade(backpack, upgradeInQuestion)) {
                upgradeInQuestion = null;
            } else {
                nullChecksPassed = true;
            }
        }
        boolean upgradeRemoved = false;
        NBTTagList tagList = new NBTTagList();
        for (ItemStack upgrade : upgrades) {
            if (nullChecksPassed && UpgradeMethods.areUpgradesFunctionallyEquivalent(upgrade, upgradeInQuestion)) {
                upgradeRemoved = true;
                if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(upgradeInQuestion)) continue;
                nbtTagCompound.func_74782_a("RemovedAltGui", (NBTBase)upgradeInQuestion.func_77955_b(new NBTTagCompound()));
                continue;
            }
            tagList.func_74742_a((NBTBase)upgrade.func_77955_b(new NBTTagCompound()));
        }
        nbtTagCompound.func_74782_a("Upgrades", (NBTBase)tagList);
        if (upgradeRemoved) {
            this.upgradeRemovedStack = upgradeInQuestion;
            return result;
        }
        this.upgradeRemovedStack = null;
        return null;
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList required = new ArrayList(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        if (this.upgradeRemovedStack != null) {
            ItemStack[] ret = new ItemStack[inv.func_70302_i_()];
            ret[0] = this.upgradeRemovedStack.func_77946_l();
            for (int i = 1; i < ret.length; ++i) {
                ret[i] = null;
            }
            return ret;
        }
        return super.func_179532_b(inv);
    }

    private int getFirstUpgradableBackpackSlotNumber(InventoryCrafting inventoryCrafting) {
        for (int i = 0; i < 9; ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            if (itemstack == null || !(itemstack.func_77973_b() instanceof IUpgradableBackpack)) continue;
            return i;
        }
        return -1;
    }

    public static int findEmptySlot(IInventory inventoryCrafting) {
        for (int i = 0; i < 9; ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            if (itemstack != null) continue;
            return i;
        }
        return -1;
    }

    private boolean canRemoveNestingUpgrade(ItemStack backpack, ItemStack upgrade) {
        if (ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(upgrade) && (ItemIUpgradeRegistry.getItemIConflictingUpgrade(upgrade.func_77952_i()).equals(ItemRegistry.nestingUpgrade) || ItemIUpgradeRegistry.getItemIConflictingUpgrade(upgrade.func_77952_i()).equals(ItemRegistry.nestingAdvancedUpgrade))) {
            InventoryBackpack inventoryBackpack = new InventoryBackpack(backpack, true);
            for (int i = 0; i < inventoryBackpack.func_70302_i_(); ++i) {
                if (inventoryBackpack.func_70301_a(i) == null || !(inventoryBackpack.func_70301_a(i).func_77973_b() instanceof ItemBackpack)) continue;
                return false;
            }
        }
        return true;
    }
}

