/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.client.gui.buttons;

import gr8pefish.ironbackpacks.api.client.gui.button.ButtonNames;
import gr8pefish.ironbackpacks.api.client.gui.button.IGuiButton;
import gr8pefish.ironbackpacks.api.client.gui.button.ITooltipButton;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.registry.GuiButtonRegistry;
import gr8pefish.ironbackpacks.util.IronBackpacksConstants;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TooltipButton
extends GuiButton
implements ITooltipButton {
    public static final ResourceLocation widgetTextures = IronBackpacksConstants.Resources.WIDGETS;
    private int buttonID;
    private int iconOffsetX;
    private int iconOffsetY;
    private ArrayList<String> tooltips;
    private int hoverTime;

    public TooltipButton(IGuiButton guiButton, int xPos, int yPos) {
        super(guiButton.getId(), xPos, yPos, guiButton.getSizeX(), guiButton.getSizeY(), "");
        this.buttonID = guiButton.getId();
        this.hoverTime = guiButton.shouldDelay() ? ConfigHandler.tooltipDelay : 0;
        this.tooltips = new ArrayList();
        for (String string : guiButton.getTooltip()) {
            this.tooltips.add(string);
        }
        this.iconOffsetX = guiButton.getIconOffsetX();
        this.iconOffsetY = guiButton.getIconOffsetY();
    }

    public TooltipButton(int id, IGuiButton guiButton, int xPos, int yPos, String ... tooltipLines) {
        super(id, xPos, yPos, guiButton.getSizeX(), guiButton.getSizeY(), "");
        this.buttonID = id;
        this.hoverTime = guiButton.shouldDelay() ? ConfigHandler.tooltipDelay : 0;
        this.tooltips = new ArrayList();
        for (String string : tooltipLines.length == 0 ? guiButton.getTooltip() : tooltipLines) {
            this.tooltips.add(string);
        }
        this.iconOffsetX = guiButton.getIconOffsetX();
        this.iconOffsetY = guiButton.getIconOffsetY();
    }

    public void func_146112_a(Minecraft minecraft, int mPosX, int mPosY) {
        if (this.field_146125_m) {
            minecraft.func_110434_K().func_110577_a(widgetTextures);
            boolean hover = this.mouseInButton(mPosX, mPosY);
            int h = this.func_146114_a(hover);
            int fromLeft = this.iconOffsetX + (h - 1) * (this.field_146120_f + 1);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, fromLeft, this.iconOffsetY, this.field_146120_f, this.field_146121_g);
        }
    }

    @Override
    public boolean mouseInButton(int mPosX, int mPosY) {
        return mPosX >= this.field_146128_h && mPosY >= this.field_146129_i && mPosX < this.field_146128_h + this.field_146120_f && mPosY < this.field_146129_i + this.field_146121_g;
    }

    @Override
    public ArrayList<String> getTooltip() {
        return this.tooltips;
    }

    public void setTooltip(ArrayList<String> newTooltips) {
        this.tooltips = newTooltips;
    }

    @Override
    public int getHoverTime() {
        return this.hoverTime;
    }

    public static int incrementType(GuiButton button) {
        int buttonID = ((TooltipButton)button).buttonID;
        if (buttonID < GuiButtonRegistry.getButton(ButtonNames.VOID).getId()) {
            return ++buttonID;
        }
        return GuiButtonRegistry.getButton(ButtonNames.EXACT).getId();
    }
}

