/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api.register;

import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.items.upgrades.ItemIConfigurableUpgrade;
import gr8pefish.ironbackpacks.api.items.upgrades.ItemIConflictingUpgrade;
import gr8pefish.ironbackpacks.api.items.upgrades.ItemIUpgrade;
import gr8pefish.ironbackpacks.api.items.upgrades.interfaces.IUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIUpgradeRegistry {
    private static List<ItemIUpgrade> upgradesIUpgrade = new ArrayList<ItemIUpgrade>();
    private static List<ItemIConflictingUpgrade> upgradesIConflictingUpgrade = new ArrayList<ItemIConflictingUpgrade>();
    private static List<ItemIConfigurableUpgrade> upgradesIConfigurableUpgrade = new ArrayList<ItemIConfigurableUpgrade>();

    public static void registerItemPackUpgrade(ItemIUpgrade item) {
        if (!upgradesIUpgrade.contains(item)) {
            upgradesIUpgrade.add(item);
        }
    }

    public static void registerItemConflictingUpgrade(ItemIConflictingUpgrade item) {
        if (!upgradesIConflictingUpgrade.contains(item)) {
            upgradesIConflictingUpgrade.add(item);
        }
    }

    public static void registerItemConfigurableUpgrade(ItemIConfigurableUpgrade item) {
        if (!upgradesIConfigurableUpgrade.contains(item)) {
            upgradesIConfigurableUpgrade.add(item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemIUpgradeTexture(ItemIUpgrade item, String modelName) {
        int meta = ItemIUpgradeRegistry.getIndexOfIUpgrade(item);
        ResourceLocation resourceLocation = new ResourceLocation("ironbackpacks:" + modelName);
        ModelBakery.registerItemVariants((Item)IronBackpacksAPI.getItem("upgrade"), (ResourceLocation[])new ResourceLocation[]{resourceLocation});
        ModelLoader.setCustomModelResourceLocation((Item)IronBackpacksAPI.getItem("upgrade"), (int)meta, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemIConflictingUpgradeTexture(ItemIConflictingUpgrade item, String modelName) {
        int meta = ItemIUpgradeRegistry.getIndexOfIConflictingUpgrade(item);
        ResourceLocation resourceLocation = new ResourceLocation("ironbackpacks:" + modelName);
        ModelBakery.registerItemVariants((Item)IronBackpacksAPI.getItem("upgrade"), (ResourceLocation[])new ResourceLocation[]{resourceLocation});
        ModelLoader.setCustomModelResourceLocation((Item)IronBackpacksAPI.getItem("upgrade"), (int)meta, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemIConfigurableUpgradeTexture(ItemIConfigurableUpgrade item, String modelName) {
        int meta = ItemIUpgradeRegistry.getIndexOfIConfigurableUpgrade(item);
        ResourceLocation resourceLocation = new ResourceLocation("ironbackpacks:" + modelName);
        ModelBakery.registerItemVariants((Item)IronBackpacksAPI.getItem("upgrade"), (ResourceLocation[])new ResourceLocation[]{resourceLocation});
        ModelLoader.setCustomModelResourceLocation((Item)IronBackpacksAPI.getItem("upgrade"), (int)meta, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, "inventory"));
    }

    public static boolean isInstanceOfAnyUpgrade(ItemStack stack) {
        return stack.func_77952_i() < ItemIUpgradeRegistry.getInflatedSizeOfConfigurable();
    }

    public static boolean isInstanceOfIUpgrade(ItemStack stack) {
        return stack.func_77952_i() < upgradesIUpgrade.size();
    }

    public static boolean isInstanceOfIConflictingUpgrade(ItemStack stack) {
        return upgradesIUpgrade.size() <= stack.func_77952_i() && stack.func_77952_i() < ItemIUpgradeRegistry.getInflatedSizeOfConflicting();
    }

    public static boolean isInstanceOfIConfigurableUpgrade(ItemStack stack) {
        return ItemIUpgradeRegistry.getInflatedSizeOfConflicting() <= stack.func_77952_i() && stack.func_77952_i() < ItemIUpgradeRegistry.getInflatedSizeOfConfigurable();
    }

    public static IUpgrade getItemUpgrade(ItemStack itemStack) {
        if (ItemIUpgradeRegistry.isInstanceOfIUpgrade(itemStack)) {
            return ItemIUpgradeRegistry.getItemIUpgrade(itemStack.func_77952_i());
        }
        if (ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(itemStack)) {
            return ItemIUpgradeRegistry.getItemIConflictingUpgrade(itemStack.func_77952_i());
        }
        if (ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(itemStack)) {
            return ItemIUpgradeRegistry.getItemIConfingurableUpgrade(itemStack.func_77952_i());
        }
        throw new RuntimeException("No items upgrade found here");
    }

    public static ItemIUpgrade getItemIUpgrade(ItemStack stack) {
        return upgradesIUpgrade.get(stack.func_77952_i());
    }

    public static ItemIConflictingUpgrade getItemIConflictingUpgrade(ItemStack stack) {
        return upgradesIConflictingUpgrade.get(stack.func_77952_i() - upgradesIUpgrade.size());
    }

    public static ItemIConfigurableUpgrade getItemIConfingurableUpgrade(ItemStack stack) {
        return upgradesIConfigurableUpgrade.get(stack.func_77952_i() - ItemIUpgradeRegistry.getInflatedSizeOfConflicting());
    }

    public static ItemIUpgrade getItemIUpgrade(int damageValue) {
        return upgradesIUpgrade.get(damageValue);
    }

    public static ItemIConflictingUpgrade getItemIConflictingUpgrade(int damageValue) {
        return upgradesIConflictingUpgrade.get(damageValue - upgradesIUpgrade.size());
    }

    public static ItemIConfigurableUpgrade getItemIConfingurableUpgrade(int damageValue) {
        return upgradesIConfigurableUpgrade.get(damageValue - ItemIUpgradeRegistry.getInflatedSizeOfConflicting());
    }

    public static int getIndexOfIUpgrade(ItemIUpgrade item) {
        return upgradesIUpgrade.indexOf(item);
    }

    public static int getIndexOfIConflictingUpgrade(ItemIConflictingUpgrade item) {
        return upgradesIUpgrade.size() + upgradesIConflictingUpgrade.indexOf(item);
    }

    public static int getIndexOfIConfigurableUpgrade(ItemIConfigurableUpgrade item) {
        return upgradesIUpgrade.size() + upgradesIConflictingUpgrade.size() + upgradesIConfigurableUpgrade.indexOf(item);
    }

    private static int getInflatedSizeOfConflicting() {
        return upgradesIUpgrade.size() + upgradesIConflictingUpgrade.size();
    }

    private static int getInflatedSizeOfConfigurable() {
        return upgradesIUpgrade.size() + upgradesIConflictingUpgrade.size() + upgradesIConfigurableUpgrade.size();
    }

    public static int getUninflatedIndexOfConfigurableUpgrade(ItemIConfigurableUpgrade upgrade) {
        return upgradesIConfigurableUpgrade.indexOf(upgrade);
    }

    public static int getIPackSize() {
        return upgradesIUpgrade.size();
    }

    public static int getTotalSize() {
        return upgradesIUpgrade.size() + upgradesIConflictingUpgrade.size() + upgradesIConfigurableUpgrade.size();
    }

    public static IRecipe getItemRecipe(int index) {
        if (index < upgradesIUpgrade.size()) {
            return upgradesIUpgrade.get(index).getItemRecipe(null);
        }
        if (index < ItemIUpgradeRegistry.getInflatedSizeOfConflicting()) {
            return ItemIUpgradeRegistry.getItemIConflictingUpgrade(index).getItemRecipe(null);
        }
        return ItemIUpgradeRegistry.getItemIConfingurableUpgrade(index).getItemRecipe(null);
    }
}

