/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mixin.transformer;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.mixin.MixinManager;
import reborncore.mixin.api.Constructor;
import reborncore.mixin.api.Inject;
import reborncore.mixin.api.Rewrite;
import reborncore.mixin.implementations.forge.MixinForgeLoadingCore;

public class MixinTransformer
implements IClassTransformer {
    public static ClassPool cp = new ClassPool(true);

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (MixinManager.mixinTargetMap.containsKey(transformedName)) {
            try {
                MixinManager.logger.trace("Mixin Transformer being called by " + Thread.currentThread().getStackTrace()[3].getClassName());
                if (Thread.currentThread().getStackTrace()[3].getClassName().equals("org.spongepowered.asm.mixin.transformer.TreeInfo")) {
                    MixinManager.logger.trace("Skipping mixin transformer as it is being called by Sponge.");
                    return basicClass;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (MixinManager.transformedClasses.contains(name)) {
                MixinManager.logger.trace("Skipping mixin transformer as the transformer has already transformed this class");
                return basicClass;
            }
            long start = System.currentTimeMillis();
            cp.insertClassPath(new ByteArrayClassPath(name, basicClass));
            CtClass target = null;
            try {
                target = cp.get(name);
            }
            catch (NotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to generate target infomation");
            }
            if (target.isFrozen()) {
                target.defrost();
            }
            if (!transformedName.startsWith("net.minecraft")) {
                MixinManager.mixinRemaper.remap(target, cp);
            }
            List<String> mixins = MixinManager.mixinTargetMap.get(transformedName);
            MixinManager.logger.info("Found " + mixins.size() + " mixins for " + transformedName);
            for (String mixinClassName : mixins) {
                CtClass mixinClass = null;
                try {
                    mixinClass = cp.get(mixinClassName);
                }
                catch (NotFoundException e) {
                    throw new RuntimeException(e);
                }
                try {
                    MixinManager.mixinRemaper.remap(mixinClass, cp);
                    for (CtMethod ctMethod : mixinClass.getMethods()) {
                        CtMethod generatedMethod;
                        if (ctMethod.hasAnnotation(Rewrite.class)) {
                            Rewrite annotation = (Rewrite)ctMethod.getAnnotation(Rewrite.class);
                            generatedMethod = CtNewMethod.copy(ctMethod, mixinClass.getName().replace(".", "$") + "$" + ctMethod.getName(), target, null);
                            target.addMethod(generatedMethod);
                            CtMethod targetMethod = null;
                            Optional<Pair<String, String>> remappedTargetInfo = MixinManager.mixinRemaper.getFullTargetName(annotation, name);
                            for (CtMethod methodCandidate : target.getMethods()) {
                                if (!remappedTargetInfo.isPresent()) {
                                    if (!methodCandidate.getName().equals(annotation.target()) || !methodCandidate.getSignature().equals(ctMethod.getSignature())) continue;
                                    targetMethod = methodCandidate;
                                    break;
                                }
                                if (!(methodCandidate.getName() + methodCandidate.getSignature()).equals(remappedTargetInfo.get().getRight())) continue;
                                targetMethod = methodCandidate;
                                break;
                            }
                            if (targetMethod == null) {
                                MixinManager.logger.error("Could not find method to inject into");
                                throw new RuntimeException("Could not find method " + (MixinForgeLoadingCore.runtimeDeobfuscationEnabled && !annotation.targetSRG().isEmpty() ? annotation.targetSRG() : annotation.target()) + " to inject into");
                            }
                            String src = null;
                            String mCall = annotation.isStatic() ? "" : "this.";
                            switch (annotation.returnBehavor()) {
                                case NONE: {
                                    src = mCall + mixinClass.getName().replace(".", "$") + "$" + ctMethod.getName() + "($$);";
                                    break;
                                }
                                case OBJECT_NONE_NULL: {
                                    src = "Object mixinobj = " + mCall + generatedMethod.getName() + "($$);if(mixinobj != null){return ($w)mixinobj;}";
                                    break;
                                }
                                case BOOL_TRUE: {
                                    if (!ctMethod.getReturnType().getName().equals("boolean")) {
                                        throw new RuntimeException(ctMethod.getName() + " does not return a boolean");
                                    }
                                    if (targetMethod.getReturnType().getName().equals("boolean")) {
                                        src = "if(" + mCall + generatedMethod.getName() + "($$)){return true;}";
                                        break;
                                    }
                                    src = "if(" + mCall + generatedMethod.getName() + "($$)){return;}";
                                    break;
                                }
                                default: {
                                    src = mCall + mixinClass.getName().replace(".", "$") + "$" + ctMethod.getName() + "($$);";
                                }
                            }
                            switch (annotation.behavior()) {
                                case START: {
                                    targetMethod.insertBefore(src);
                                    break;
                                }
                                case END: {
                                    targetMethod.insertAfter(src);
                                    break;
                                }
                                case REPLACE: {
                                    targetMethod.setBody(src);
                                }
                            }
                            continue;
                        }
                        if (ctMethod.hasAnnotation(Inject.class)) {
                            String methodName = ctMethod.getName();
                            Inject inject = (Inject)ctMethod.getAnnotation(Inject.class);
                            if (inject.rename()) {
                                methodName = mixinClass.getName().replace(".", "$") + "$" + ctMethod.getName();
                            }
                            CtMethod generatedMethod2 = CtNewMethod.copy(ctMethod, methodName, target, null);
                            target.addMethod(generatedMethod2);
                            continue;
                        }
                        if (!ctMethod.hasAnnotation(Constructor.class)) continue;
                        Constructor constructor = (Constructor)ctMethod.getAnnotation(Constructor.class);
                        generatedMethod = CtNewMethod.copy(ctMethod, mixinClass.getName().replace(".", "$") + "$" + ctMethod.getName(), target, null);
                        target.addMethod(generatedMethod);
                        CtConstructor targetConstructor = target.getConstructor(constructor.signature());
                        String src = "this." + mixinClass.getName().replace(".", "$") + "$" + ctMethod.getName() + "($$);";
                        targetConstructor.insertAfter(src);
                    }
                    for (CtMember ctMember : mixinClass.getFields()) {
                        if (!ctMember.hasAnnotation(Inject.class)) continue;
                        CtField generatedField = new CtField((CtField)ctMember, target);
                        target.addField(generatedField);
                    }
                    for (CtClass ctClass : mixinClass.getInterfaces()) {
                        target.addInterface(ctClass);
                    }
                    for (CtConstructor ctConstructor : mixinClass.getConstructors()) {
                        if (!ctConstructor.hasAnnotation(Inject.class)) continue;
                        CtConstructor generatedConstructor = CtNewConstructor.copy(ctConstructor, target, null);
                        target.addConstructor(generatedConstructor);
                    }
                }
                catch (ClassNotFoundException | CannotCompileException | NotFoundException e) {
                    throw new RuntimeException(e);
                }
                MixinManager.logger.info("Successfully applied " + mixinClassName + " to " + name);
            }
            try {
                MixinManager.logger.info("Successfully applied " + mixins.size() + " mixins to " + name + " in " + (System.currentTimeMillis() - start) + "ms");
                MixinManager.transformedClasses.add(name);
                return target.toBytecode();
            }
            catch (IOException | CannotCompileException e) {
                throw new RuntimeException(e);
            }
        }
        return basicClass;
    }
}

