/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ItemStackSerializer
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    private static final String NAME = "name";
    private static final String META_VALUE = "metaValue";
    private static final String STACK_SIZE = "stackSize";
    private static final String TAG_COMPOUND = "tagCompound";

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            String name = null;
            int metaValue = 0;
            int stackSize = 1;
            NBTTagCompound tagCompound = null;
            if (jsonObject.has(NAME) && jsonObject.get(NAME).isJsonPrimitive()) {
                name = jsonObject.getAsJsonPrimitive(NAME).getAsString();
            }
            if (jsonObject.has(META_VALUE) && jsonObject.get(META_VALUE).isJsonPrimitive()) {
                try {
                    metaValue = jsonObject.getAsJsonPrimitive(META_VALUE).getAsInt();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (jsonObject.has(STACK_SIZE) && jsonObject.get(STACK_SIZE).isJsonPrimitive()) {
                stackSize = jsonObject.getAsJsonPrimitive(STACK_SIZE).getAsInt();
            }
            if (jsonObject.has(TAG_COMPOUND) && jsonObject.get(TAG_COMPOUND).isJsonPrimitive()) {
                try {
                    tagCompound = JsonToNBT.func_180713_a((String)jsonObject.getAsJsonPrimitive(TAG_COMPOUND).getAsString());
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
            }
            if (name != null && Item.func_111206_d((String)name) != null) {
                ItemStack itemStack = new ItemStack(Item.func_111206_d((String)name), stackSize, metaValue);
                itemStack.func_77982_d(tagCompound);
                return itemStack;
            }
        }
        return null;
    }

    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        if (src != null && src.func_77973_b() != null) {
            JsonObject jsonObject = new JsonObject();
            if (Item.field_150901_e.func_177774_c((Object)src.func_77973_b()) == null) {
                return JsonNull.INSTANCE;
            }
            jsonObject.addProperty(NAME, ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)src.func_77973_b())).toString());
            if (src.func_77952_i() != 0) {
                jsonObject.addProperty(META_VALUE, (Number)src.func_77952_i());
            }
            jsonObject.addProperty(STACK_SIZE, (Number)src.field_77994_a);
            if (src.func_77978_p() != null) {
                jsonObject.addProperty(TAG_COMPOUND, src.func_77978_p().toString());
            }
            return jsonObject;
        }
        return JsonNull.INSTANCE;
    }
}

