/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.tile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IContainerProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.client.gui.slots.SlotInput;
import reborncore.client.gui.slots.SlotOutput;
import reborncore.common.container.RebornContainer;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.IInventoryUpdateable;
import reborncore.common.util.inventory.Inventory;

public abstract class TileMachineInventory
extends TileMachineBase
implements IInventoryProvider,
IContainerProvider,
IInventoryUpdateable {
    private final Inventory inventoryBase;
    private Map<EnumFacing, IItemHandler> sidedHandlers = new HashMap<EnumFacing, IItemHandler>();

    public TileMachineInventory(EnumPowerTier tier, int capacity, int costPerTick, int ticksNeeded, String inventoryName, int inventorySize, int inventoryStackLimit) {
        super(tier, capacity, costPerTick, ticksNeeded);
        this.inventoryBase = new Inventory(inventoryName, inventorySize, inventoryStackLimit, this);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.sidedHandlers.put(facing, new InventoryItemHandler(facing));
        }
    }

    @Override
    public Inventory getInventory() {
        return this.inventoryBase;
    }

    @Override
    public void updateInventory() {
        this.markBlockForUpdate();
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventoryBase.readFromNBT(data);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        this.inventoryBase.writeToNBT(data);
        return super.func_189515_b(data);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.getInventory().isDirty = false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)super.getCapability(capability, facing);
    }

    protected Optional<RecipeCrafter> getCrafterForTile() {
        if (this instanceof IRecipeCrafterProvider) {
            IRecipeCrafterProvider crafterProvider = (IRecipeCrafterProvider)((Object)this);
            if (crafterProvider.getRecipeCrafter() == null) {
                return Optional.empty();
            }
            return Optional.of(crafterProvider.getRecipeCrafter());
        }
        return Optional.empty();
    }

    private class InventoryItemHandler
    implements IItemHandler {
        private final EnumFacing facing;
        private Map<EnumFacing, List<BaseSlot>> slotMap = new HashMap<EnumFacing, List<BaseSlot>>();

        InventoryItemHandler(EnumFacing facing) {
            this.facing = facing;
            RebornContainer container = TileMachineInventory.this.getContainer();
            for (EnumFacing _facing : EnumFacing.field_82609_l) {
                ArrayList<BaseSlot> slotList = new ArrayList<BaseSlot>();
                for (Map.Entry<Integer, BaseSlot> entry : container.slotMap.entrySet()) {
                    BaseSlot baseSlot = entry.getValue();
                    if (_facing == EnumFacing.UP && baseSlot instanceof SlotInput) {
                        slotList.add(baseSlot);
                        continue;
                    }
                    if (_facing == EnumFacing.DOWN && baseSlot instanceof SlotOutput) {
                        slotList.add(baseSlot);
                        continue;
                    }
                    slotList.add(baseSlot);
                }
                this.slotMap.put(_facing, slotList);
            }
        }

        public int getSlots() {
            return this.slotMap.get(this.facing).size();
        }

        public ItemStack getStackInSlot(int slotIndex) {
            return this.slotMap.get(this.facing).get(slotIndex).func_75211_c();
        }

        public ItemStack insertItem(int slotIndex, ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack == null || stack.field_77994_a == 0) {
                return null;
            }
            Slot slot = this.slotMap.get(this.facing).get(slotIndex);
            if (!slot.func_75216_d()) {
                slot.func_75215_d(stack);
                return null;
            }
            ItemStack existing = slot.func_75211_c();
            int limit = slot.func_75219_a();
            if (existing != null) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.field_77994_a;
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.field_77994_a > limit;
            if (!simulate) {
                if (existing == null) {
                    slot.func_75215_d(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
                } else {
                    existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
                }
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
        }

        public ItemStack extractItem(int slotIndex, int amount, boolean simulate) {
            if (amount == 0) {
                return null;
            }
            Slot slot = this.slotMap.get(this.facing).get(slotIndex);
            if (slot.func_75211_c() == null) {
                return null;
            }
            ItemStack existing = slot.func_75211_c();
            if (existing == null) {
                return null;
            }
            int toExtract = Math.min(amount, existing.func_77976_d());
            if (existing.field_77994_a <= toExtract) {
                if (!simulate) {
                    slot.func_75215_d(null);
                }
                return existing;
            }
            if (!simulate) {
                slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.field_77994_a - toExtract)));
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
        }
    }
}

