/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.recipes;

import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import reborncore.RebornCore;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.recipes.RecipeTranslator;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class RecipeCrafter {
    public String recipeName;
    public TileEntity parentTile;
    public IEnergyInterfaceTile energy;
    public int inputs;
    public int outputs;
    public IInventory inventory;
    public int[] inputSlots;
    public int[] outputSlots;
    public IBaseRecipeType currentRecipe;
    public int currentTickTime = 0;
    public int currentNeededTicks = 1;
    double lastEnergy;
    double speedMultiplier = 0.0;
    double powerMultiplier = 1.0;
    int ticksSinceLastChange;

    public RecipeCrafter(String recipeName, TileMachineBase parentTile, int inputs, int outputs, reborncore.common.util.inventory.Inventory inventory, int[] inputSlots, int[] outputSlots) {
        this.recipeName = recipeName;
        this.parentTile = parentTile;
        if (parentTile instanceof IEnergyInterfaceTile) {
            this.energy = parentTile;
        }
        this.inputs = inputs;
        this.outputs = outputs;
        this.inventory = inventory;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        if (!(parentTile instanceof IRecipeCrafterProvider)) {
            RebornCore.logHelper.error(parentTile.getClass().getName() + " does not use IRecipeCrafterProvider report this to the issue tracker!");
        }
    }

    @Deprecated
    public RecipeCrafter(String recipeName, TileEntity parentTile, int inputs, int outputs, Inventory inventory, int[] inputSlots, int[] outputSlots) {
        this.recipeName = recipeName;
        this.parentTile = parentTile;
        if (parentTile instanceof IEnergyInterfaceTile) {
            this.energy = (IEnergyInterfaceTile)parentTile;
        }
        this.inputs = inputs;
        this.outputs = outputs;
        this.inventory = inventory;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        if (!(parentTile instanceof IRecipeCrafterProvider)) {
            RebornCore.logHelper.error(parentTile.getClass().getName() + " does not use IRecipeCrafterProvider report this to the issue tracker!");
        }
    }

    public void updateEntity() {
        if (this.parentTile.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange == 20) {
            this.setInvDirty(true);
            this.ticksSinceLastChange = 0;
        }
        if (this.currentRecipe == null && this.isInvDirty()) {
            this.currentTickTime = 0;
            for (IBaseRecipeType recipe : RecipeHandler.getRecipeClassFromName(this.recipeName)) {
                if (!recipe.canCraft(this.parentTile) || !this.hasAllInputs(recipe)) continue;
                boolean canGiveInvAll = true;
                for (int i = 0; i < recipe.getOutputsSize(); ++i) {
                    if (this.canFitStack(recipe.getOutput(i), this.outputSlots[i], recipe.useOreDic())) continue;
                    canGiveInvAll = false;
                    return;
                }
                if (canGiveInvAll) {
                    this.setCurrentRecipe(recipe);
                    this.currentNeededTicks = (int)((double)this.currentRecipe.tickTime() * (1.0 - this.speedMultiplier));
                    this.currentTickTime = -1;
                    this.setIsActive();
                    continue;
                }
                this.currentTickTime = -1;
            }
        } else {
            if (this.isInvDirty() && !this.hasAllInputs()) {
                this.currentRecipe = null;
                this.currentTickTime = -1;
                this.setIsActive();
            }
            if (this.currentRecipe != null && this.currentTickTime >= this.currentNeededTicks) {
                boolean canGiveInvAll = true;
                for (int i = 0; i < this.currentRecipe.getOutputsSize(); ++i) {
                    if (this.canFitStack(this.currentRecipe.getOutput(i), this.outputSlots[i], this.currentRecipe.useOreDic())) continue;
                    canGiveInvAll = false;
                }
                ArrayList<Integer> filledSlots = new ArrayList<Integer>();
                if (canGiveInvAll && this.currentRecipe.onCraft(this.parentTile)) {
                    for (int i = 0; i < this.currentRecipe.getOutputsSize(); ++i) {
                        if (filledSlots.contains(this.outputSlots[i])) continue;
                        this.fitStack(this.currentRecipe.getOutput(i).func_77946_l(), this.outputSlots[i]);
                        filledSlots.add(this.outputSlots[i]);
                    }
                    this.useAllInputs();
                    this.currentRecipe = null;
                    this.currentTickTime = -1;
                    this.setIsActive();
                }
            } else if (this.currentRecipe != null && this.currentTickTime < this.currentNeededTicks && this.energy.canUseEnergy(this.getEuPerTick())) {
                this.energy.useEnergy(this.getEuPerTick());
                ++this.currentTickTime;
            }
        }
        this.setInvDirty(false);
    }

    public boolean hasAllInputs() {
        if (this.currentRecipe == null) {
            return false;
        }
        for (Object input : this.currentRecipe.getInputs()) {
            boolean hasItem = false;
            boolean useOreDict = input instanceof String || this.currentRecipe.useOreDic();
            boolean checkSize = input instanceof ItemStack;
            for (int inputslot : this.inputSlots) {
                if (!ItemUtils.isInputEqual(input, this.inventory.func_70301_a(inputslot), true, true, useOreDict)) continue;
                ItemStack stack = RecipeTranslator.getStackFromObject(input);
                if (checkSize && this.inventory.func_70301_a((int)inputslot).field_77994_a < stack.field_77994_a) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllInputs(IBaseRecipeType recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (Object input : recipeType.getInputs()) {
            boolean hasItem = false;
            boolean useOreDict = input instanceof String || recipeType.useOreDic();
            boolean checkSize = input instanceof ItemStack;
            for (int inputslot : this.inputSlots) {
                if (!ItemUtils.isInputEqual(input, this.inventory.func_70301_a(inputslot), true, true, useOreDict)) continue;
                ItemStack stack = RecipeTranslator.getStackFromObject(input);
                if (checkSize && this.inventory.func_70301_a((int)inputslot).field_77994_a < stack.field_77994_a) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    public void useAllInputs() {
        if (this.currentRecipe == null) {
            return;
        }
        block0: for (Object input : this.currentRecipe.getInputs()) {
            for (int inputSlot : this.inputSlots) {
                if (!ItemUtils.isInputEqual(input, this.inventory.func_70301_a(inputSlot), true, true, this.currentRecipe.useOreDic())) continue;
                int count = 1;
                if (input instanceof ItemStack) {
                    count = RecipeTranslator.getStackFromObject((Object)input).field_77994_a;
                }
                this.inventory.func_70298_a(inputSlot, count);
                continue block0;
            }
        }
    }

    public boolean canFitStack(ItemStack stack, int slot, boolean oreDic) {
        if (stack == null) {
            return true;
        }
        if (this.inventory.func_70301_a(slot) == null) {
            return true;
        }
        return ItemUtils.isItemEqual(this.inventory.func_70301_a(slot), stack, true, true, oreDic) && stack.field_77994_a + this.inventory.func_70301_a((int)slot).field_77994_a <= stack.func_77976_d();
    }

    public void fitStack(ItemStack stack, int slot) {
        if (stack == null) {
            return;
        }
        if (this.inventory.func_70301_a(slot) == null) {
            this.inventory.func_70299_a(slot, stack);
            return;
        }
        if (ItemUtils.isItemEqual(this.inventory.func_70301_a(slot), stack, true, true, this.currentRecipe.useOreDic()) && stack.field_77994_a + this.inventory.func_70301_a((int)slot).field_77994_a <= stack.func_77976_d()) {
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = this.inventory.func_70301_a((int)slot).field_77994_a + stack.field_77994_a;
            this.inventory.func_70299_a(slot, newStack);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("Crater");
        if (data.func_74764_b("currentTickTime")) {
            this.currentTickTime = data.func_74762_e("currentTickTime");
        }
        if (this.parentTile != null && this.parentTile.func_145831_w() != null && this.parentTile.func_145831_w().field_72995_K) {
            this.parentTile.func_145831_w().func_184138_a(this.parentTile.func_174877_v(), this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()), this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()), 3);
            this.parentTile.func_145831_w().func_147458_c(this.parentTile.func_174877_v().func_177958_n(), this.parentTile.func_174877_v().func_177956_o(), this.parentTile.func_174877_v().func_177952_p(), this.parentTile.func_174877_v().func_177958_n(), this.parentTile.func_174877_v().func_177956_o(), this.parentTile.func_174877_v().func_177952_p());
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("currentTickTime", (double)this.currentTickTime);
        tag.func_74782_a("Crater", (NBTBase)data);
    }

    private boolean isActive() {
        return this.currentRecipe != null && this.energy.getEnergy() >= (double)this.currentRecipe.euPerTick();
    }

    private boolean canCraftAgain() {
        for (IBaseRecipeType recipe : RecipeHandler.getRecipeClassFromName(this.recipeName)) {
            if (!recipe.canCraft(this.parentTile) || !this.hasAllInputs(recipe)) continue;
            boolean canGiveInvAll = true;
            for (int i = 0; i < recipe.getOutputsSize(); ++i) {
                if (this.canFitStack(recipe.getOutput(i), this.outputSlots[i], recipe.useOreDic())) continue;
                canGiveInvAll = false;
                return false;
            }
            if (this.energy.getEnergy() < (double)recipe.euPerTick()) {
                return false;
            }
            return canGiveInvAll;
        }
        return false;
    }

    public void addSpeedMulti(double amount) {
        this.speedMultiplier = this.speedMultiplier + amount <= 0.99 ? (this.speedMultiplier += amount) : 0.99;
    }

    public void resetSpeedMulti() {
        this.speedMultiplier = 0.0;
    }

    public double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public void addPowerMulti(double amount) {
        this.powerMultiplier += amount;
    }

    public void resetPowerMulti() {
        this.powerMultiplier = 1.0;
    }

    public double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public double getEuPerTick() {
        return (double)this.currentRecipe.euPerTick() * this.powerMultiplier;
    }

    public void setIsActive() {
        if (this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()).func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()).func_177230_c();
            boolean isActive = this.isActive() || this.canCraftAgain();
            blockMachineBase.setActive(isActive, this.parentTile.func_145831_w(), this.parentTile.func_174877_v());
        }
        this.parentTile.func_145831_w().func_184138_a(this.parentTile.func_174877_v(), this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()), this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()), 3);
    }

    public void setCurrentRecipe(IBaseRecipeType recipe) {
        try {
            this.currentRecipe = (IBaseRecipeType)recipe.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public boolean isInvDirty() {
        if (this.inventory instanceof reborncore.common.util.inventory.Inventory) {
            return ((reborncore.common.util.inventory.Inventory)this.inventory).isDirty;
        }
        if (this.inventory instanceof Inventory) {
            return ((Inventory)this.inventory).hasChanged;
        }
        return true;
    }

    public void setInvDirty(boolean isDiry) {
        if (this.inventory instanceof reborncore.common.util.inventory.Inventory) {
            ((reborncore.common.util.inventory.Inventory)this.inventory).isDirty = isDiry;
        } else if (this.inventory instanceof Inventory) {
            ((Inventory)this.inventory).hasChanged = isDiry;
        }
    }
}

