/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.mixin;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import reborncore.api.item.IColoredDamageBar;
import reborncore.api.power.IEnergyInterfaceItem;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItem;
import reborncore.mixin.api.Inject;
import reborncore.mixin.api.Mixin;

@Mixin(target="")
public abstract class BasePowerMixin
implements IEnergyInterfaceItem,
IColoredDamageBar {
    @Override
    @Inject
    public double getEnergy(ItemStack stack) {
        NBTTagCompound tagCompound = this.getOrCreateNbtData(stack);
        if (tagCompound.func_74764_b("charge")) {
            return tagCompound.func_74769_h("charge");
        }
        return 0.0;
    }

    @Override
    @Inject
    public void setEnergy(double energy, ItemStack stack) {
        NBTTagCompound tagCompound = this.getOrCreateNbtData(stack);
        tagCompound.func_74780_a("charge", energy);
        if (this.getEnergy(stack) > this.getMaxPower(stack)) {
            this.setEnergy(this.getMaxPower(stack), stack);
        } else if (this.getEnergy(stack) < 0.0) {
            this.setEnergy(0.0, stack);
        }
    }

    @Override
    @Inject
    public double addEnergy(double energy, ItemStack stack) {
        return this.addEnergy(energy, false, stack);
    }

    @Override
    @Inject
    public double addEnergy(double energy, boolean simulate, ItemStack stack) {
        double energyReceived = Math.min(this.getMaxPower(stack) - energy, Math.min(this.getMaxPower(stack), energy));
        if (!simulate) {
            this.setEnergy(energy + energyReceived, stack);
        }
        return energyReceived;
    }

    @Override
    @Inject
    public boolean canUseEnergy(double input, ItemStack stack) {
        return input <= this.getEnergy(stack);
    }

    @Override
    @Inject
    public double useEnergy(double energy, ItemStack stack) {
        return this.useEnergy(energy, false, stack);
    }

    @Override
    @Inject
    public double useEnergy(double extract, boolean simulate, ItemStack stack) {
        double energyExtracted = Math.min(extract, Math.min(this.getMaxTransfer(stack), extract));
        if (!simulate) {
            this.setEnergy(this.getEnergy(stack) - energyExtracted, stack);
        }
        return energyExtracted;
    }

    @Override
    @Inject
    public boolean canAddEnergy(double energy, ItemStack stack) {
        return this.getEnergy(stack) + energy <= this.getMaxPower(stack);
    }

    @Inject
    public NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    @Inject
    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = PoweredItem.getEnergy(stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    @Inject
    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Override
    @Inject
    public boolean showRGBDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    @Inject
    public int getRGBDurabilityForBar(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }
}

