/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import java.util.HashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.PacketWrapper;
import reborncore.common.network.RegisterPacketEvent;

public class NetworkManager {
    public static final SimpleNetworkWrapper NETWORK_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("rebornCore");
    public static HashMap<Integer, Class<? extends INetworkPacket>> packetHashMap = new HashMap();
    public static HashMap<Class<? extends INetworkPacket>, Integer> packetHashMapReverse = new HashMap();

    public static void load() {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterPacketEvent(NETWORK_WRAPPER));
    }

    public static void sendToServer(INetworkPacket packet) {
        if (!packetHashMap.containsValue(packet.getClass())) {
            throw new RuntimeException("Packet " + packet.getClass().getName() + " has not been registered");
        }
        NETWORK_WRAPPER.sendToServer((IMessage)new PacketWrapper(packet));
    }

    public static void sendToAllAround(INetworkPacket packet, NetworkRegistry.TargetPoint point) {
        if (!packetHashMap.containsValue(packet.getClass())) {
            throw new RuntimeException("Packet " + packet.getClass().getName() + " has not been registered");
        }
        NETWORK_WRAPPER.sendToAllAround((IMessage)new PacketWrapper(packet), point);
    }
}

