/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import reborncore.RebornCore;
import reborncore.api.tile.IContainerLayout;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.client.gui.slots.SlotFake;

public abstract class RebornContainer
extends Container {
    public HashMap<Integer, BaseSlot> slotMap = new HashMap();
    private static HashMap<String, RebornContainer> containerMap = new HashMap();

    protected Slot func_75146_a(Slot slotIn) {
        Slot slot = super.func_75146_a(slotIn);
        if (slot instanceof BaseSlot) {
            this.slotMap.put(slot.getSlotIndex(), (BaseSlot)slot);
        }
        return slot;
    }

    @Nullable
    public static RebornContainer getContainerFromClass(Class<? extends RebornContainer> clazz, TileEntity tileEntity) {
        return RebornContainer.createContainer(clazz, tileEntity, RebornCore.proxy.getPlayer());
    }

    public static RebornContainer createContainer(Class<? extends RebornContainer> clazz, TileEntity tileEntity, EntityPlayer player) {
        if (player == null && containerMap.containsKey(clazz.getCanonicalName())) {
            return containerMap.get(clazz.getCanonicalName());
        }
        try {
            RebornContainer container = null;
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterCount() == 0) {
                    container = clazz.newInstance();
                    if (!(container instanceof IContainerLayout)) continue;
                    ((IContainerLayout)((Object)container)).setTile(tileEntity);
                    ((IContainerLayout)((Object)container)).addInventorySlots();
                    continue;
                }
                if (constructor.getParameterCount() != 2) continue;
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (paramTypes[0].isInstance(tileEntity) && paramTypes[1] == EntityPlayer.class) {
                    container = clazz.getDeclaredConstructor(tileEntity.getClass(), EntityPlayer.class).newInstance(tileEntity, player);
                    continue;
                }
                if (paramTypes[0] != EntityPlayer.class || !paramTypes[1].isInstance(tileEntity)) continue;
                container = clazz.getDeclaredConstructor(EntityPlayer.class, tileEntity.getClass()).newInstance(player, tileEntity);
            }
            if (container == null) {
                RebornCore.logHelper.error("Failed to create container for " + clazz.getName() + " bad things may happen, please report to devs");
            }
            containerMap.put(clazz.getCanonicalName(), container);
            return container;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int numSlots = this.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.field_77994_a <= 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || !RebornContainer.canStacksMerge(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                if (resultingStackSize <= max) {
                    stackToShift.field_77994_a = 0;
                    stackInSlot.field_77994_a = resultingStackSize;
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.field_77994_a >= max) continue;
                stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
                stackInSlot.field_77994_a = max;
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.field_77994_a > 0) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
                stackToShift.field_77994_a -= stackInSlot.field_77994_a;
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (slot instanceof SlotFake || !slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public void addPlayersHotbar(EntityPlayer player) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 142));
        }
    }

    public void addPlayersInventory(EntityPlayer player) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    public void drawPlayersInv(EntityPlayer player) {
        this.drawPlayersInv(player, 8, 81);
    }

    public void drawPlayersHotBar(EntityPlayer player) {
        this.drawPlayersHotBar(player, 8, 139);
    }

    public void drawPlayersInv(EntityPlayer player, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new BaseSlot((IInventory)player.field_71071_by, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
    }

    public void drawPlayersHotBar(EntityPlayer player, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new BaseSlot((IInventory)player.field_71071_by, i, x + i * 18, y));
        }
    }

    public void drawPlayersInvAndHotbar(EntityPlayer player) {
        this.drawPlayersInv(player);
        this.drawPlayersHotBar(player);
    }

    public void drawPlayersInvAndHotbar(EntityPlayer player, int x, int y) {
        this.drawPlayersInv(player, x, y);
        this.drawPlayersHotBar(player, x, y);
    }
}

