/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.network;

import io.netty.buffer.Unpooled;
import mod.flatcoloredblocks.network.ModPacket;
import mod.flatcoloredblocks.network.ModPacketTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class NetworkRouter {
    public static NetworkRouter instance;
    final FMLEventChannel ec;
    final String channelName = "flatcoloredblocks";
    final ServerPacketHandler serverPacketHandler;
    final ClientPacketHandler clientPacketHandler;

    public NetworkRouter() {
        ModPacketTypes.init();
        this.ec = NetworkRegistry.INSTANCE.newEventDrivenChannel("flatcoloredblocks");
        this.ec.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.clientPacketHandler = new ClientPacketHandler();
        this.serverPacketHandler = new ServerPacketHandler();
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.getPacket().handler();
        try {
            if (this.serverPacketHandler != null) {
                this.serverPacketHandler.onPacketData(ev.getPacket(), ev.getHandler(), srv.field_147369_b);
            }
        }
        catch (ThreadQuickExitException threadQuickExitException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        try {
            if (this.clientPacketHandler != null) {
                this.clientPacketHandler.onPacketData(ev.getPacket(), ev.getHandler());
            }
        }
        catch (ThreadQuickExitException threadQuickExitException) {
            // empty catch block
        }
    }

    private ModPacket parsePacket(PacketBuffer buffer) {
        byte id = buffer.readByte();
        try {
            ModPacket packet = ModPacketTypes.constructByID(id);
            packet.readPayload(buffer);
            return packet;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private FMLProxyPacket getProxyPacket(ModPacket packet) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeByte(ModPacketTypes.getID(packet.getClass()));
        packet.getPayload(buffer);
        return new FMLProxyPacket(buffer, "flatcoloredblocks");
    }

    public void sendToServer(ModPacket packet) {
        this.ec.sendToServer(this.getProxyPacket(packet));
    }

    public void sendToAll(ModPacket packet) {
        this.ec.sendToAll(this.getProxyPacket(packet));
    }

    public void sendTo(ModPacket packet, EntityPlayerMP player) {
        this.ec.sendTo(this.getProxyPacket(packet), player);
    }

    public void sendToAllAround(ModPacket packet, NetworkRegistry.TargetPoint point) {
        this.ec.sendToAllAround(this.getProxyPacket(packet), point);
    }

    private class ServerPacketHandler {
        private ServerPacketHandler() {
        }

        public void onPacketData(FMLProxyPacket packet, INetHandler handler, EntityPlayerMP playerEntity) {
            if (playerEntity == null) {
                return;
            }
            PacketBuffer buffer = new PacketBuffer(packet.payload());
            ModPacket innerPacket = NetworkRouter.this.parsePacket(buffer);
            innerPacket.serverEntity = playerEntity;
            PacketThreadUtil.func_180031_a((Packet)innerPacket, (INetHandler)handler, (IThreadListener)playerEntity.func_184102_h());
            innerPacket.server(playerEntity);
        }
    }

    private class ClientPacketHandler {
        private ClientPacketHandler() {
        }

        public void onPacketData(FMLProxyPacket packet, INetHandler handler) {
            PacketBuffer buffer = new PacketBuffer(packet.payload());
            ModPacket innerPacket = NetworkRouter.this.parsePacket(buffer);
            PacketThreadUtil.func_180031_a((Packet)innerPacket, (INetHandler)handler, (IThreadListener)Minecraft.func_71410_x());
            innerPacket.client();
        }
    }
}

