/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.block;

import java.util.HashMap;

public class ConversionHSV2RGB {
    private static HashMap<Integer, Integer> conversion = new HashMap();

    private static int fromHSV(double in_h, double in_s, double in_v) {
        double out_r = 0.0;
        double out_g = 0.0;
        double out_b = 0.0;
        if (in_s <= 0.0) {
            out_r = in_v;
            out_g = in_v;
            out_b = in_v;
            return ConversionHSV2RGB.rgb(out_r, out_g, out_b);
        }
        double hueWheel = in_h * 360.0;
        if (hueWheel >= 360.0) {
            hueWheel = 0.0;
        }
        int hueWheelPart = (int)(hueWheel /= 60.0);
        double ff = hueWheel - (double)hueWheelPart;
        double p = in_v * (1.0 - in_s);
        double q = in_v * (1.0 - in_s * ff);
        double t = in_v * (1.0 - in_s * (1.0 - ff));
        switch (hueWheelPart) {
            case 0: {
                out_r = in_v;
                out_g = t;
                out_b = p;
                break;
            }
            case 1: {
                out_r = q;
                out_g = in_v;
                out_b = p;
                break;
            }
            case 2: {
                out_r = p;
                out_g = in_v;
                out_b = t;
                break;
            }
            case 3: {
                out_r = p;
                out_g = q;
                out_b = in_v;
                break;
            }
            case 4: {
                out_r = t;
                out_g = p;
                out_b = in_v;
                break;
            }
            default: {
                out_r = in_v;
                out_g = p;
                out_b = q;
            }
        }
        return ConversionHSV2RGB.rgb(out_r, out_g, out_b);
    }

    private static int rgb(double out_r, double out_g, double out_b) {
        int r = Math.min(255, Math.max(0, (int)(out_r * 255.0)));
        int g = Math.min(255, Math.max(0, (int)(out_g * 255.0)));
        int b = Math.min(255, Math.max(0, (int)(out_b * 255.0)));
        return r << 16 | g << 8 | b;
    }

    public static int toRGB(int hsvFromState) {
        Integer rgb = conversion.get(hsvFromState);
        if (rgb == null) {
            int h = hsvFromState >> 16 & 0xFF;
            int s = hsvFromState >> 8 & 0xFF;
            int v = hsvFromState & 0xFF;
            rgb = ConversionHSV2RGB.fromHSV((double)h / 255.0, (double)s / 255.0, (double)v / 255.0);
            conversion.put(hsvFromState, rgb);
        }
        return rgb;
    }
}

