/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.block;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import mod.flatcoloredblocks.FlatColoredBlocks;
import mod.flatcoloredblocks.block.BlockFlatColoredTranslucent;
import mod.flatcoloredblocks.block.BlockHSVConfiguration;
import mod.flatcoloredblocks.block.ConversionHSV2RGB;
import mod.flatcoloredblocks.block.EnumFlatBlockType;
import mod.flatcoloredblocks.block.EnumFlatColorAttributes;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BlockFlatColored
extends Block {
    private static ArrayList<BlockFlatColored> coloredBlocks = new ArrayList();
    private static int offset;
    private static BlockHSVConfiguration newConfig;
    private int shadeOffset;
    private int maxShade;
    private BlockHSVConfiguration configuration;
    private PropertyInteger shade;
    private final int varient;
    public final int opacity;
    public final int field_149784_t;

    public MapColor func_180659_g(IBlockState state) {
        for (EnumFlatColorAttributes attr : this.getFlatColorAttributes(state)) {
            if (attr.isModifier) continue;
            return attr.mapColor;
        }
        return MapColor.field_151666_j;
    }

    public int colorFromState(IBlockState state) {
        int fullAlpha = -16777216;
        return ConversionHSV2RGB.toRGB(this.hsvFromState(state)) | 0xFF000000;
    }

    public int getShadeNumber(IBlockState state) {
        if (state.func_177230_c() instanceof BlockFlatColored) {
            BlockFlatColored cb = (BlockFlatColored)state.func_177230_c();
            return (Integer)state.func_177229_b((IProperty)cb.shade) + cb.shadeOffset;
        }
        return 0;
    }

    public int hsvFromState(IBlockState state) {
        if (state == null) {
            return 0;
        }
        return this.configuration.hsvFromNumber(this.getShadeNumber(state));
    }

    public int getShadeOffset() {
        return this.shadeOffset;
    }

    public int getMaxShade() {
        return this.maxShade;
    }

    public IProperty<Integer> getShade() {
        return this.shade;
    }

    protected BlockFlatColored(float lightValue, float opacity, int varientNum) {
        super((double)opacity > 0.001 ? Material.field_151592_s : Material.field_151576_e);
        this.func_149663_c("flatcoloredblocks.flatcoloredblock." + offset);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149715_a(FlatColoredBlocks.instance.config.GLOWING_EMITS_LIGHT ? Math.max(0.0f, Math.min(15.0f, lightValue / 255.0f)) : 0.0f);
        this.func_149713_g((double)opacity > 0.001 ? 0 : 255);
        this.func_149672_a((double)opacity > 0.001 ? SoundType.field_185853_f : SoundType.field_185851_d);
        this.field_149785_s = (double)opacity > 0.001;
        this.varient = varientNum;
        coloredBlocks.add(this);
        this.opacity = 100 - Math.round(opacity * 100.0f / 255.0f);
        this.field_149784_t = (int)(lightValue * 15.0f / 255.0f);
    }

    public static BlockFlatColored construct(BlockHSVConfiguration type, int offsetIn, int varientNum) {
        offset = offsetIn;
        newConfig = type;
        switch (type.type) {
            case GLOWING: {
                return new BlockFlatColored(type.shadeConvertVariant[varientNum], 0.0f, varientNum);
            }
            case NORMAL: {
                return new BlockFlatColored(0.0f, 0.0f, varientNum);
            }
            case TRANSPARENT: {
                return new BlockFlatColoredTranslucent(0, type.shadeConvertVariant[varientNum], varientNum);
            }
        }
        throw new RuntimeException("Invalid construction.");
    }

    protected BlockStateContainer func_180661_e() {
        this.shadeOffset = offset;
        this.configuration = newConfig;
        this.maxShade = this.shadeOffset + this.configuration.META_SCALE_MINUS_ONE;
        if (this.configuration.MAX_SHADES_MINUS_ONE < this.maxShade) {
            this.maxShade = this.configuration.MAX_SHADES_MINUS_ONE;
            IProperty[] iPropertyArray = new IProperty[1];
            this.shade = PropertyInteger.func_177719_a((String)"shade", (int)0, (int)(this.maxShade - this.shadeOffset));
            iPropertyArray[0] = this.shade;
            return new BlockStateContainer((Block)this, iPropertyArray);
        }
        IProperty[] iPropertyArray = new IProperty[1];
        this.shade = PropertyInteger.func_177719_a((String)"shade", (int)0, (int)this.configuration.META_SCALE_MINUS_ONE);
        iPropertyArray[0] = this.shade;
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.shade);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.shade, (Comparable)Integer.valueOf(meta));
    }

    public CreativeTabs func_149708_J() {
        return FlatColoredBlocks.instance.creativeTab;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    private void outputShades(List<ItemStack> list, int qty) {
        Item item = Item.func_150898_a((Block)this);
        for (int x = this.shadeOffset; x <= this.maxShade; ++x) {
            list.add(new ItemStack(item, qty, x - this.shadeOffset));
        }
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        this.outputShades(list, 1);
    }

    public static void getAllShades(List<ItemStack> list) {
        for (BlockFlatColored cb : coloredBlocks) {
            cb.outputShades(list, cb.getCraftCount());
        }
    }

    public static List<BlockFlatColored> getAllBlocks() {
        return coloredBlocks;
    }

    private int getCraftCount() {
        if (this.getCraftable() == EnumFlatBlockType.NORMAL) {
            return FlatColoredBlocks.instance.config.solidCraftingOutput;
        }
        if (this.getCraftable() == EnumFlatBlockType.TRANSPARENT) {
            return FlatColoredBlocks.instance.config.transparentCraftingOutput;
        }
        if (this.getCraftable() == EnumFlatBlockType.GLOWING) {
            return FlatColoredBlocks.instance.config.glowingCraftingOutput;
        }
        return 1;
    }

    public Set<EnumFlatColorAttributes> getFlatColorAttributes(IBlockState state) {
        int out = this.hsvFromState(state);
        EnumSet<EnumFlatColorAttributes> result = EnumSet.noneOf(EnumFlatColorAttributes.class);
        int h = (out >> 16 & 0xFF) * 360 / 255;
        int s = out >> 8 & 0xFF;
        int v = out & 0xFF;
        if (s == 0) {
            if (v < 64) {
                return EnumSet.of(EnumFlatColorAttributes.black);
            }
            if (v > 192) {
                return EnumSet.of(EnumFlatColorAttributes.white);
            }
            if (v > 128) {
                return EnumSet.of(EnumFlatColorAttributes.silver);
            }
            return EnumSet.of(EnumFlatColorAttributes.grey);
        }
        if (v < 128 && (double)s > 0.001) {
            result.add(EnumFlatColorAttributes.dark);
        } else if (v > 192 && s < 128 && (double)s > 0.001) {
            result.add(EnumFlatColorAttributes.light);
        }
        if (h >= 15 && h <= 45) {
            result.add(EnumFlatColorAttributes.orange);
        } else if (h >= 255 && h <= 285) {
            result.add(EnumFlatColorAttributes.violet);
        } else if (h >= 315 && h <= 345) {
            result.add(EnumFlatColorAttributes.pink);
        } else if (h >= 60 && h <= 90) {
            result.add(EnumFlatColorAttributes.lime);
        } else if (h >= 195 && h <= 225) {
            result.add(EnumFlatColorAttributes.azure);
        } else if (h >= 125 && h <= 155) {
            result.add(EnumFlatColorAttributes.emerald);
        } else if (h >= 330 || h <= 30) {
            result.add(EnumFlatColorAttributes.red);
        } else if (h >= 30 && h <= 90) {
            result.add(EnumFlatColorAttributes.yellow);
        } else if (h >= 90 && h <= 150) {
            result.add(EnumFlatColorAttributes.green);
        } else if (h >= 150 && h <= 210) {
            result.add(EnumFlatColorAttributes.cyan);
        } else if (h >= 210 && h <= 270) {
            result.add(EnumFlatColorAttributes.blue);
        } else {
            result.add(EnumFlatColorAttributes.magenta);
        }
        return result;
    }

    public EnumFlatBlockType getType() {
        return this.configuration.type;
    }

    public int getVarient() {
        return this.configuration.shadeConvertVariant[this.varient];
    }

    public EnumFlatBlockType getCraftable() {
        return this.configuration.type;
    }
}

