/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.betterthanbunnies.common;

import me.ichun.mods.betterthanbunnies.common.render.LayerFancyBunny;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderRabbit;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="betterthanbunnies", name="BetterThanBunnies", version="1.10.2-1.1.0", clientSideOnly=true, acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.9.4,1.10.2]")
public class BetterThanBunnies {
    public boolean hasShownFirstGui;
    public static int fancyWeightage = 80;
    public static int randomizeSuitParts = 1;
    public static String[] disabledSuitParts = new String[0];

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        config.addCustomCategoryComment("general", "General settings");
        fancyWeightage = config.getInt("fancyWeightage", "general", 80, 0, 100, "Weightage of bunnies wearing parts of their outfit, in percentage% (0-100)");
        randomizeSuitParts = config.getInt("randomizeSuitParts", "general", 1, 0, 1, "0 = Render the entire outfit (except disabled parts)\n1 = Randomly choose which parts of the outfit to render (per bunny)");
        disabledSuitParts = config.getStringList("disabledSuitParts", "general", disabledSuitParts, "Disable parts of the outfit", new String[]{"hat", "monocle", "pipe", "suit"});
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!this.hasShownFirstGui) {
            this.hasShownFirstGui = true;
            Render renderer = Minecraft.func_71410_x().func_175598_ae().func_78715_a(EntityRabbit.class);
            if (renderer instanceof RenderRabbit) {
                RenderRabbit renderRabbit = (RenderRabbit)renderer;
                renderRabbit.func_177094_a((LayerRenderer)new LayerFancyBunny(renderRabbit));
            }
        }
    }
}

