/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;

public enum EnumPlacement implements IStringSerializable
{
    WALL(0, "wall"),
    FLOOR(1, "floor"),
    CEILING(2, "ceiling");

    private final String name;
    private final int index;
    public static final EnumPlacement[] VALUES;
    private static final Map<String, EnumPlacement> NAME_LOOKUP;

    private EnumPlacement(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public static EnumPlacement getPlacement(int index) {
        return VALUES[MathHelper.func_76130_a((int)(index % VALUES.length))];
    }

    public static EnumPlacement getPlacementFromFacing(EnumFacing facing) {
        if (facing.func_176740_k().func_176722_c()) {
            return WALL;
        }
        if (facing.func_176743_c().func_179524_a() > 0) {
            return FLOOR;
        }
        return CEILING;
    }

    public static EnumPlacement byName(String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase());
    }

    static {
        VALUES = new EnumPlacement[3];
        NAME_LOOKUP = Maps.newHashMap();
        EnumPlacement[] enumPlacementArray = EnumPlacement.values();
        int n = enumPlacementArray.length;
        for (int i = 0; i < n; ++i) {
            EnumPlacement enumPlacement;
            EnumPlacement.VALUES[enumPlacement.index] = enumPlacement = enumPlacementArray[i];
            NAME_LOOKUP.put(enumPlacement.func_176610_l().toLowerCase(), enumPlacement);
        }
    }
}

