/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.network.messages;

import edgarallen.mods.scf.blocks.incinerationframe.TileEntityIncinerationFrame;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSpawnIncinerationParticles
implements IMessage {
    private BlockPos pos;
    private float hitX;
    private float hitY;
    private float hitZ;

    public MessageSpawnIncinerationParticles() {
    }

    public MessageSpawnIncinerationParticles(BlockPos pos, float hitX, float hitY, float hitZ) {
        this.pos = pos;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeFloat(this.hitX);
        buf.writeFloat(this.hitY);
        buf.writeFloat(this.hitZ);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.hitX = buf.readFloat();
        this.hitY = buf.readFloat();
        this.hitZ = buf.readFloat();
    }

    public static class Handler
    implements IMessageHandler<MessageSpawnIncinerationParticles, IMessage> {
        public IMessage onMessage(MessageSpawnIncinerationParticles message, MessageContext ctx) {
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
            if (thread.func_152345_ab()) {
                this.handle(message, ctx);
            } else {
                thread.func_152344_a(() -> this.handle(message, ctx));
            }
            return null;
        }

        private void handle(MessageSpawnIncinerationParticles message, MessageContext ctx) {
            World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            TileEntity te = world.func_175625_s(message.pos);
            if (te != null && te instanceof TileEntityIncinerationFrame) {
                TileEntityIncinerationFrame tile = (TileEntityIncinerationFrame)te;
                tile.spawnParticles(message.hitX, message.hitY, message.hitZ);
            }
        }
    }
}

