/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.teleportationframe.nbt;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.DimensionManager;

public class DestinationMarkerNBTWriter {
    public static void writeNBTToStack(ItemStack stack, Vec3d positionVector, float rotationYaw, int dimension) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList destTagList = new NBTTagList();
        NBTTagCompound rootCompound = new NBTTagCompound();
        DestinationMarkerNBTWriter.writePositionToNBT(rootCompound, positionVector);
        DestinationMarkerNBTWriter.writeRotationYawToNBT(rootCompound, rotationYaw);
        DestinationMarkerNBTWriter.writeDimensionToNBT(rootCompound, dimension);
        destTagList.func_74742_a((NBTBase)rootCompound);
        stack.func_77978_p().func_74782_a("dest", (NBTBase)destTagList);
    }

    private static void writePositionToNBT(NBTTagCompound rootCompound, Vec3d positionVector) {
        rootCompound.func_74780_a("x", positionVector.field_72450_a);
        rootCompound.func_74780_a("y", positionVector.field_72448_b);
        rootCompound.func_74780_a("z", positionVector.field_72449_c);
    }

    private static void writeRotationYawToNBT(NBTTagCompound rootCompound, float rotationYaw) {
        rootCompound.func_74776_a("yaw", rotationYaw);
    }

    private static void writeDimensionToNBT(NBTTagCompound rootCompound, int dimension) {
        rootCompound.func_74768_a("dim", dimension);
        String name = DimensionManager.getWorld((int)dimension).field_73011_w.func_186058_p().func_186065_b();
        rootCompound.func_74778_a("dimName", name);
    }

    public static void clearNBT(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("dest");
        }
    }
}

