/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.itemframe;

import edgarallen.mods.scf.blocks.common.BlockBaseFrame;
import edgarallen.mods.scf.blocks.itemframe.TileEntityItemFrame;
import edgarallen.mods.scf.blocks.itemframe.TileEntityItemFrameRenderer;
import edgarallen.mods.scf.blocks.itemframe.nbt.ItemFrameNBTReader;
import edgarallen.mods.scf.blocks.itemframe.nbt.ItemFrameNBTWriter;
import edgarallen.mods.scf.blocks.itemframe.recipes.ItemFrameShapelessRecipe;
import edgarallen.mods.scf.config.Config;
import edgarallen.mods.scf.items.ModItems;
import edgarallen.mods.scf.network.ThePacketeer;
import edgarallen.mods.scf.network.messages.MessageClearItemFrame;
import edgarallen.mods.scf.network.messages.MessageExtractItem;
import edgarallen.mods.scf.network.messages.MessageInsertItem;
import edgarallen.mods.scf.network.messages.MessageInstantBreak;
import edgarallen.mods.scf.util.CommonUtils;
import edgarallen.mods.scf.util.EnumPlacement;
import edgarallen.mods.scf.util.EnumType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;

public class BlockItemFrame
extends BlockBaseFrame
implements ITileEntityProvider {
    public static final String NAME = "super_item_frame";

    public BlockItemFrame() {
        super(Material.field_151575_d);
        this.func_149663_c(NAME);
        this.setRegistryName(NAME);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.registerTileEntity(TileEntityItemFrame.class, (String)NAME);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.itemFrameItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityItemFrame.class, (TileEntitySpecialRenderer)new TileEntityItemFrameRenderer());
    }

    public void registerRecipes() {
        RecipeSorter.register((String)"supercraftingframe:item_shapeless", ItemFrameShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this, 1, 0), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), Items.field_151055_y, Character.valueOf('X'), Blocks.field_150409_cd});
        ArrayList<Object> ingredients = new ArrayList<ItemStack>();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new ItemFrameShapelessRecipe(new ItemStack((Block)this, 1, 1), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new ItemFrameShapelessRecipe(new ItemStack((Block)this, 1, 2), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new ItemFrameShapelessRecipe(new ItemStack((Block)this, 1, 2), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new ItemFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new ItemFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 2));
        GameRegistry.addRecipe((IRecipe)new ItemFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 1));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new ItemFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, 0), (Object[])new Object[]{new ItemStack((Block)this, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, 1), (Object[])new Object[]{new ItemStack((Block)this, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, 2), (Object[])new Object[]{new ItemStack((Block)this, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, 3), (Object[])new Object[]{new ItemStack((Block)this, 1, 3)});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityItemFrame) {
            TileEntityItemFrame tileFrame = (TileEntityItemFrame)tile;
            if (stack.func_77942_o()) {
                ItemFrameNBTReader.readFromNBT(tileFrame, stack.func_77978_p());
            } else {
                EnumType type = EnumType.getType(stack.func_77960_j());
                tileFrame.initFrame(type);
            }
        }
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
            BlockPos hitPos = ray.func_178782_a();
            float hitX = (float)(ray.field_72307_f.field_72450_a - (double)hitPos.func_177958_n());
            float hitY = (float)(ray.field_72307_f.field_72448_b - (double)hitPos.func_177956_o());
            float hitZ = (float)(ray.field_72307_f.field_72449_c - (double)hitPos.func_177952_p());
            TileEntityItemFrame tile = (TileEntityItemFrame)worldIn.func_175625_s(pos);
            EnumType type = tile.getType();
            IBlockState state = worldIn.func_180495_p(pos);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b((IProperty)PLACEMENT));
            if (playerIn.func_70093_af()) {
                this.performBlockClickAction(Config.itemFrameSneakLeftClick, pos, CommonUtils.getSubFrameIndex(type, facing, placement, hitX, hitY, hitZ));
            } else {
                this.performBlockClickAction(Config.itemFrameLeftClick, pos, CommonUtils.getSubFrameIndex(type, facing, placement, hitX, hitY, hitZ));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            TileEntityItemFrame tile = (TileEntityItemFrame)worldIn.func_175625_s(pos);
            EnumType type = tile.getType();
            if (playerIn.func_70093_af()) {
                if (heldItem == null) {
                    ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageClearItemFrame(pos, CommonUtils.getSubFrameIndex(type, (EnumFacing)state.func_177229_b((IProperty)FACING), (EnumPlacement)((Object)state.func_177229_b((IProperty)PLACEMENT)), hitX, hitY, hitZ)));
                } else {
                    this.performBlockClickAction(Config.itemFrameSneakRightClick, pos, CommonUtils.getSubFrameIndex(type, (EnumFacing)state.func_177229_b((IProperty)FACING), (EnumPlacement)((Object)state.func_177229_b((IProperty)PLACEMENT)), hitX, hitY, hitZ));
                }
            } else {
                this.performBlockClickAction(Config.itemFrameRightClick, pos, CommonUtils.getSubFrameIndex(type, (EnumFacing)state.func_177229_b((IProperty)FACING), (EnumPlacement)((Object)state.func_177229_b((IProperty)PLACEMENT)), hitX, hitY, hitZ));
            }
        }
        return true;
    }

    private void performBlockClickAction(TileEntityItemFrame.Action action, BlockPos pos, int subFrameIndex) {
        switch (action) {
            case EXTRACT_ITEM: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageExtractItem(pos, subFrameIndex, false));
                break;
            }
            case EXTRACT_STACK: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageExtractItem(pos, subFrameIndex, true));
                break;
            }
            case INSERT_STACK: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageInsertItem(pos, subFrameIndex, false));
                break;
            }
            case INSERT_ALL_STACKS: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageInsertItem(pos, subFrameIndex, true));
                break;
            }
            case INSTANT_BREAK: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageInstantBreak(pos));
                break;
            }
        }
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityItemFrame tile;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntityItemFrame tileEntityItemFrame = tile = world.func_175625_s(pos) instanceof TileEntityItemFrame ? (TileEntityItemFrame)world.func_175625_s(pos) : null;
        if (tile != null) {
            int meta = tile.getType().ordinal();
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, meta);
            if (tile.areAnyFiltersSet()) {
                NBTTagCompound compound = new NBTTagCompound();
                ItemFrameNBTWriter.writeToNBT(tile.getType(), tile.getFilters(), compound);
                stack.func_77982_d(compound);
            }
            list.add(stack);
        }
        return list;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityItemFrame();
    }
}

