/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.craftingframe.gui;

import edgarallen.mods.scf.blocks.craftingframe.TileEntityCraftingFrame;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ContainerCraftingFrame
extends Container {
    private static final int MIDDLE_MOUSE_BUTTON = 2;
    private TileEntityCraftingFrame tileEntity;
    private int subFrame;
    private List<ItemStack> recipeOutputs = Collections.emptyList();
    private int recipeIndex = 0;
    private InventoryCraftingWrapper wrapper = new InventoryCraftingWrapper();

    public ContainerCraftingFrame(InventoryPlayer playerInventory, TileEntityCraftingFrame tileEntity, int subFrame) {
        this.tileEntity = tileEntity;
        this.subFrame = subFrame;
        this.initContainerSlots(playerInventory);
        this.trySetRecipeFromTileEntity();
    }

    private void initContainerSlots(InventoryPlayer playerInventory) {
        int j;
        int i;
        this.func_75146_a(new Slot(this.wrapper.craftResult, 0, 119, 41){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer playerIn) {
                return false;
            }
        });
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotGhost((IInventory)this.wrapper.craftMatrix, j + i * 3, 30 + j * 18, 17 + i * 18 + 6));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 6));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 148));
        }
    }

    private void trySetRecipeFromTileEntity() {
        for (int slot = 0; slot < this.wrapper.craftMatrix.func_70302_i_(); ++slot) {
            this.wrapper.craftMatrix.func_70299_a(slot, this.tileEntity.getSubFrame(this.subFrame).getRecipeItem(slot));
        }
        this.recipeOutputs = this.getRecipesOutputs();
        if (this.recipeOutputs.size() > 0) {
            this.recipeIndex = this.getRecipeIndex(this.tileEntity.getSubFrame(this.subFrame).getRecipeOutput());
            ItemStack stack = this.recipeOutputs.get(this.recipeIndex);
            this.wrapper.craftResult.func_70299_a(0, stack);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tileEntity.isUseableByPlayer(playerIn);
    }

    public boolean hasMultipleRecipeOutputs() {
        return this.recipeOutputs.size() > 1;
    }

    private int getRecipeIndex(ItemStack recipeOutput) {
        for (int i = 0; i < this.recipeOutputs.size(); ++i) {
            if (!ItemStack.func_185132_d((ItemStack)this.recipeOutputs.get(i), (ItemStack)recipeOutput)) continue;
            return i;
        }
        return 0;
    }

    public List<ItemStack> getRecipesOutputs() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        return recipes.stream().filter(recipe -> recipe.func_77569_a(this.wrapper.craftMatrix, this.tileEntity.func_145831_w())).map(IRecipe::func_77571_b).collect(Collectors.toList());
    }

    public void nextRecipe() {
        this.recipeIndex = this.recipeIndex + 1 >= this.recipeOutputs.size() ? 0 : this.recipeIndex + 1;
        this.wrapper.craftResult.func_70299_a(0, this.recipeOutputs.get(this.recipeIndex));
        this.wrapper.craftResult.func_70296_d();
    }

    public void prevRecipe() {
        this.recipeIndex = this.recipeIndex - 1 < 0 ? this.recipeOutputs.size() - 1 : this.recipeIndex - 1;
        this.wrapper.craftResult.func_70299_a(0, this.recipeOutputs.get(this.recipeIndex));
        this.wrapper.craftResult.func_70296_d();
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            if (index < 10) {
                return null;
            }
            if (index >= 46) {
                if (!this.func_75135_a(stack1, 10, 46, true)) {
                    return null;
                }
                slot.func_75220_a(stack1, stack);
            }
            if (stack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stack1.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(playerIn, stack1);
        }
        return stack;
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
        this.wrapper.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.wrapper.craftMatrix, this.tileEntity.func_145831_w()));
        this.recipeOutputs = this.getRecipesOutputs();
        this.tileEntity.func_70296_d();
        BlockPos pos = this.tileEntity.func_174877_v();
        World world = this.tileEntity.func_145831_w();
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        for (int slot = 0; slot < this.wrapper.craftMatrix.func_70302_i_(); ++slot) {
            this.tileEntity.getSubFrame(this.subFrame).setRecipeItem(slot, this.wrapper.craftMatrix.func_70301_a(slot));
        }
        this.tileEntity.getSubFrame(this.subFrame).setRecipeOutput(this.wrapper.craftResult.func_70301_a(0));
        this.tileEntity.func_70296_d();
        BlockPos pos = this.tileEntity.func_174877_v();
        World world = this.tileEntity.func_145831_w();
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof SlotGhost) {
            if (dragType == 2) {
                for (int i = 0; i < 9; ++i) {
                    this.wrapper.craftMatrix.func_174888_l();
                    this.func_75130_a((IInventory)this.wrapper.craftMatrix);
                }
            } else {
                return ((SlotGhost)slot).slotClick(dragType, clickTypeIn, player);
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    private class SlotGhost
    extends Slot {
        SlotGhost(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return false;
        }

        ItemStack slotClick(int mouseButton, ClickType clickTypeIn, EntityPlayer playerIn) {
            ItemStack stack = null;
            InventoryPlayer playerInventory = playerIn.field_71071_by;
            if (clickTypeIn == ClickType.QUICK_CRAFT) {
                ItemStack stackSlot = this.func_75211_c();
                ItemStack stackHeld = playerInventory.func_70445_o();
                ItemStack itemStack = stack = stackSlot != null ? stackSlot.func_77946_l() : null;
                if (stackHeld == null) {
                    this.func_75215_d(null);
                } else {
                    ItemStack s = stackHeld.func_77946_l();
                    s.field_77994_a = 1;
                    this.func_75215_d(s);
                }
            } else if (mouseButton == 0 || mouseButton == 1) {
                ItemStack stackSlot = this.func_75211_c();
                ItemStack stackHeld = playerInventory.func_70445_o();
                ItemStack itemStack = stack = stackSlot != null ? stackSlot.func_77946_l() : null;
                if (stackHeld == null) {
                    this.func_75215_d(null);
                } else {
                    ItemStack s = stackHeld.func_77946_l();
                    s.field_77994_a = 1;
                    this.func_75215_d(s);
                }
            }
            return stack;
        }
    }

    private class InventoryCraftingWrapper {
        public IInventory craftResult = new InventoryCraftResult();
        public InventoryCrafting craftMatrix = new InventoryCrafting(ContainerCraftingFrame.this, 3, 3){

            public int func_70297_j_() {
                return 1;
            }
        };

        private InventoryCraftingWrapper() {
        }
    }
}

