/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.common;

import com.google.common.base.Predicate;
import edgarallen.mods.scf.SuperCraftingFrame;
import edgarallen.mods.scf.blocks.common.TileEntityBaseFrame;
import edgarallen.mods.scf.util.EnumPlacement;
import edgarallen.mods.scf.util.EnumType;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBaseFrame
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumPlacement> PLACEMENT = PropertyEnum.func_177709_a((String)"placement", EnumPlacement.class);
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final float PIXEL = 0.0625f;
    private static final AxisAlignedBB CEILING_AABB = new AxisAlignedBB(0.125, 1.0, 0.125, 0.875, 0.9375, 0.875);
    private static final AxisAlignedBB FLOOR_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.0625, 0.875);
    private static final AxisAlignedBB WALL_NORTH_AABB = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.0625);
    private static final AxisAlignedBB WALL_SOUTH_AABB = new AxisAlignedBB(0.125, 0.125, 1.0, 0.875, 0.875, 0.9375);
    private static final AxisAlignedBB WALL_EAST_AABB = new AxisAlignedBB(0.9375, 0.125, 0.125, 1.0, 0.875, 0.875);
    private static final AxisAlignedBB WALL_WEST_AABB = new AxisAlignedBB(0.0, 0.125, 0.125, 0.0625, 0.875, 0.875);

    public BlockBaseFrame(Material material) {
        super(material);
        this.func_149647_a(SuperCraftingFrame.superCreativeTab);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(PLACEMENT, (Comparable)((Object)EnumPlacement.WALL)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b(PLACEMENT));
        switch (placement) {
            case CEILING: {
                return CEILING_AABB;
            }
            case FLOOR: {
                return FLOOR_AABB;
            }
            case WALL: {
                switch (facing) {
                    case NORTH: {
                        return WALL_NORTH_AABB;
                    }
                    case SOUTH: {
                        return WALL_SOUTH_AABB;
                    }
                    case EAST: {
                        return WALL_EAST_AABB;
                    }
                    case WEST: {
                        return WALL_WEST_AABB;
                    }
                }
            }
        }
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)world, pos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        EnumPlacement placement = EnumPlacement.getPlacementFromFacing(facing);
        EnumFacing correctedFacing = placement == EnumPlacement.WALL ? facing.func_176734_d() : placer.func_174811_aO();
        return iblockstate.func_177226_a((IProperty)FACING, (Comparable)correctedFacing).func_177226_a(PLACEMENT, (Comparable)((Object)placement));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn);
        BlockPos neighborPos = this.getNeighborBlockPos(state, pos);
        if (worldIn.func_175623_d(neighborPos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private BlockPos getNeighborBlockPos(IBlockState state, BlockPos pos) {
        EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b(PLACEMENT));
        switch (placement) {
            case FLOOR: {
                return pos.func_177977_b();
            }
            case CEILING: {
                return pos.func_177984_a();
            }
            case WALL: {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                switch (facing) {
                    case NORTH: {
                        return pos.func_177978_c();
                    }
                    case SOUTH: {
                        return pos.func_177968_d();
                    }
                    case EAST: {
                        return pos.func_177974_f();
                    }
                    case WEST: {
                        return pos.func_177976_e();
                    }
                }
            }
        }
        return null;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public String getHarvestTool(IBlockState state) {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta >> 2))).func_177226_a(PLACEMENT, (Comparable)((Object)EnumPlacement.getPlacement(meta & 0x2F)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2 | ((EnumPlacement)((Object)state.func_177229_b(PLACEMENT))).getIndex();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        super.func_176221_a(state, worldIn, pos);
        TileEntityBaseFrame tile = (TileEntityBaseFrame)worldIn.func_175625_s(pos);
        return state.func_177226_a(TYPE, (Comparable)((Object)tile.getType()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PLACEMENT, TYPE});
    }
}

