/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.funnels;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.shadowfacts.funnels.PlayerUtils;

public class FluidUtils {
    public static boolean fillHandlerWithContainer(World world, IFluidHandler handler, EntityPlayer player, EnumHand hand) {
        ItemStack container = player.func_184586_b(hand);
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (fluid != null && (handler.fill(fluid, false) == fluid.amount || player.field_71075_bZ.field_75098_d)) {
            ItemStack returnStack = FluidContainerRegistry.drainFluidContainer((ItemStack)container);
            if (world.field_72995_K) {
                return true;
            }
            if (!player.field_71075_bZ.field_75098_d && PlayerUtils.disposePlayerItem(player.func_184586_b(hand), returnStack, player, true)) {
                player.field_71070_bA.func_75142_b();
                ((EntityPlayerMP)player).func_71120_a(player.field_71070_bA);
            }
            handler.fill(fluid, true);
            return true;
        }
        return false;
    }

    public static boolean fillContainerFromHandler(World world, IFluidHandler handler, EntityPlayer player, EnumHand hand, FluidStack tankFluid) {
        ItemStack container = player.func_184586_b(hand);
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
            ItemStack returnStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)container);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)returnStack);
            if (fluid == null || returnStack == null) {
                return false;
            }
            if (world.field_72995_K) {
                return true;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (container.field_77994_a == 1) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack);
                    --container.field_77994_a;
                    if (container.field_77994_a <= 0) {
                        container = null;
                    }
                } else if (PlayerUtils.disposePlayerItem(player.func_184586_b(hand), returnStack, player, true)) {
                    player.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)player).func_71120_a(player.field_71070_bA);
                }
            }
            handler.drain(fluid.amount, true);
            return true;
        }
        return false;
    }

    public static boolean isFluidBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockLiquid) {
            return (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
        }
        if (state.func_177230_c() instanceof IFluidBlock) {
            return ((IFluidBlock)state.func_177230_c()).canDrain(world, pos);
        }
        return false;
    }

    public static FluidStack drainFluidBlock(World world, BlockPos pos, boolean doDrain) {
        FluidStack stack = null;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockLiquid && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
                stack = new FluidStack(FluidRegistry.WATER, 1000);
                if (doDrain) {
                    world.func_175698_g(pos);
                }
            } else if (state.func_177230_c() == Blocks.field_150353_l || state.func_177230_c() == Blocks.field_150356_k) {
                stack = new FluidStack(FluidRegistry.LAVA, 1000);
                if (doDrain) {
                    world.func_175698_g(pos);
                }
            }
        } else if (state.func_177230_c() instanceof IFluidBlock) {
            stack = ((IFluidBlock)state.func_177230_c()).drain(world, pos, doDrain);
        }
        return stack;
    }
}

