/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.ItemEarmuffs;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class IETileSound
implements ITickableSound {
    protected Sound sound;
    private SoundEventAccessor soundEvent;
    private SoundCategory category;
    public ISound.AttenuationType attenuation;
    public final ResourceLocation resource;
    public float volume;
    public float pitch;
    public int tileX;
    public int tileY;
    public int tileZ;
    public boolean canRepeat;
    public int repeatDelay;
    public float volumeAjustment = 1.0f;
    public float[] origPos;
    public boolean donePlaying = false;

    public IETileSound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, ISound.AttenuationType attenuation, SoundCategory category) {
        this(event.func_187503_a(), volume, pitch, repeat, repeatDelay, x, y, z, attenuation, category);
    }

    public IETileSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, ISound.AttenuationType attenuation, SoundCategory category) {
        this.attenuation = attenuation;
        this.resource = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.tileX = x;
        this.tileY = y;
        this.tileZ = z;
        this.canRepeat = repeat;
        this.repeatDelay = repeatDelay;
        this.origPos = new float[]{x, y, z};
        this.category = category;
    }

    public IETileSound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, ISound.AttenuationType attenuation, SoundCategory category) {
        this(event.func_187503_a(), volume, pitch, repeat, repeatDelay, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), attenuation, category);
    }

    public IETileSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, ISound.AttenuationType attenuation, SoundCategory category) {
        this(sound, volume, pitch, repeat, repeatDelay, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), attenuation, category);
    }

    public ISound.AttenuationType func_147656_j() {
        return this.attenuation;
    }

    public ResourceLocation func_147650_b() {
        return this.resource;
    }

    @Nullable
    public SoundEventAccessor func_184366_a(SoundHandler handler) {
        this.soundEvent = handler.func_184398_a(this.resource);
        this.sound = this.soundEvent == null ? SoundHandler.field_147700_a : this.soundEvent.func_148720_g();
        return this.soundEvent;
    }

    public Sound func_184364_b() {
        return this.sound;
    }

    public SoundCategory func_184365_d() {
        return this.category;
    }

    public float func_147653_e() {
        return this.volume * this.volumeAjustment;
    }

    public float func_147655_f() {
        return this.pitch;
    }

    public float func_147649_g() {
        return this.tileX;
    }

    public float func_147654_h() {
        return this.tileY;
    }

    public float func_147651_i() {
        return this.tileZ;
    }

    public boolean func_147657_c() {
        return this.canRepeat;
    }

    public int func_147652_d() {
        return this.repeatDelay;
    }

    public void evaluateVolume() {
        TileEntity tile;
        this.volumeAjustment = 1.0f;
        if (ClientUtils.mc().field_71439_g != null && ClientUtils.mc().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD) != null) {
            ItemStack stack = ClientUtils.mc().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD);
            if (ItemNBTHelper.hasKey(stack, "IE:Earmuffs")) {
                stack = ItemNBTHelper.getItemStack(stack, "IE:Earmuffs");
            }
            if (stack != null && IEContent.itemEarmuffs.equals(stack.func_77973_b())) {
                this.volumeAjustment = ItemEarmuffs.getVolumeMod(stack);
            }
        }
        if (this.volumeAjustment > 0.1f) {
            for (int dx = (int)Math.floor(this.tileX - 8) >> 4; dx <= (int)Math.floor(this.tileX + 8) >> 4; ++dx) {
                for (int dz = (int)Math.floor(this.tileZ - 8) >> 4; dz <= (int)Math.floor(this.tileZ + 8) >> 4; ++dz) {
                    for (TileEntity tile2 : ClientUtils.mc().field_71439_g.field_70170_p.func_72964_e(dx, dz).func_177434_r().values()) {
                        double d;
                        if (tile2 == null || !tile2.getClass().getName().endsWith("TileEntitySoundMuffler") || tile2.func_145832_p() == 1 || !((d = tile2.func_145835_a((double)this.tileX, (double)this.tileY, (double)this.tileZ)) <= 64.0) || !(d > 0.0)) continue;
                        this.volumeAjustment = 0.1f;
                    }
                }
            }
        }
        this.donePlaying = !((tile = ClientUtils.mc().field_71439_g.field_70170_p.func_175625_s(new BlockPos(this.tileX, this.tileY, this.tileZ))) instanceof IEBlockInterfaces.ISoundTile) ? true : !((IEBlockInterfaces.ISoundTile)tile).shoudlPlaySound(this.resource.toString());
    }

    public void func_73660_a() {
        if (ClientUtils.mc().field_71439_g != null && ClientUtils.mc().field_71439_g.field_70170_p.func_82737_E() % 40L == 0L) {
            this.evaluateVolume();
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }
}

