/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.ArcFurnace")
public class ArcFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, IItemStack slag, int time, int energyPerTick, @Optional IIngredient[] additives, @Optional String specialRecipeType) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        Object[] adds = null;
        if (additives != null) {
            adds = new Object[additives.length];
            for (int i = 0; i < additives.length; ++i) {
                adds[i] = CraftTweakerHelper.toObject(additives[i]);
            }
        }
        ArcFurnaceRecipe r = new ArcFurnaceRecipe(CraftTweakerHelper.toStack(output), oInput, CraftTweakerHelper.toStack(slag), time, energyPerTick, adds);
        if (specialRecipeType != null) {
            r.setSpecialRecipeType(specialRecipeType);
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<ArcFurnaceRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = ArcFurnaceRecipe.removeRecipes(this.output);
            for (ArcFurnaceRecipe recipe : this.removedRecipes) {
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe);
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (ArcFurnaceRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    ArcFurnaceRecipe.recipeList.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing ArcFurnace Recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding ArcFurnace Recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final ArcFurnaceRecipe recipe;

        public Add(ArcFurnaceRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            ArcFurnaceRecipe.recipeList.add(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            ArcFurnaceRecipe.recipeList.remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Adding ArcFurnace Recipe for " + this.recipe.output.func_82833_r();
        }

        public String describeUndo() {
            return "Removing ArcFurnace Recipe for " + this.recipe.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

