/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.ContainerModWorkbench;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemEngineersBlueprint
extends ItemUpgradeableTool {
    public ItemEngineersBlueprint() {
        super("blueprint", 1, (String)null, new String[0]);
    }

    public static ItemStack getTypedBlueprint(String type) {
        ItemStack stack = new ItemStack((Item)IEContent.itemBlueprint, 1, 0);
        ItemNBTHelper.setString(stack, "blueprint", type);
        return stack;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        String key = ItemNBTHelper.getString(stack, "blueprint");
        if (key != null && !key.isEmpty() && BlueprintCraftingRecipe.blueprintCategories.contains(key)) {
            list.add(I18n.func_135052_a((String)("desc.immersiveengineering.info.blueprint." + key), (Object[])new Object[0]));
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.blueprint.creates1", (Object[])new Object[0]));
                BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(key);
                if (recipes.length > 0) {
                    for (int i = 0; i < recipes.length; ++i) {
                        list.add(" " + recipes[i].output.func_82833_r());
                    }
                }
            } else {
                list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.blueprint.creates0", (Object[])new Object[0]));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (String key : BlueprintCraftingRecipe.blueprintCategories) {
            ItemStack stack = new ItemStack((Item)this);
            ItemNBTHelper.setString(stack, "blueprint", key);
            list.add(stack);
        }
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        LinkedHashSet<IESlot> slots = new LinkedHashSet<IESlot>();
        slots.add(new IESlot.BlueprintInput(container, invItem, 0, 74, 21, stack));
        slots.add(new IESlot.BlueprintInput(container, invItem, 1, 92, 21, stack));
        slots.add(new IESlot.BlueprintInput(container, invItem, 2, 74, 39, stack));
        slots.add(new IESlot.BlueprintInput(container, invItem, 3, 92, 39, stack));
        slots.add(new IESlot.BlueprintInput(container, invItem, 4, 74, 57, stack));
        slots.add(new IESlot.BlueprintInput(container, invItem, 5, 92, 57, stack));
        BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(stack, "blueprint"));
        for (int i = 0; i < recipes.length; ++i) {
            int y = 21 + (i < 9 ? i / 3 : -(i - 6) / 3) * 18;
            slots.add(new IESlot.BlueprintOutput(container, invItem, 6 + i, 118 + i % 3 * 18, y, stack, recipes[i]));
        }
        return slots.toArray(new Slot[slots.size()]);
    }

    public void updateOutputs(ItemStack stack) {
        BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(stack, "blueprint"));
        ItemStack[] stored = this.getContainedItems(stack);
        ItemStack[] query = new ItemStack[6];
        for (int i = 0; i < stored.length; ++i) {
            if (i < 6) {
                query[i] = stored[i];
                continue;
            }
            stored[i] = null;
            int craftable = recipes[i - 6].getMaxCrafted(query);
            if (craftable <= 0) continue;
            stored[i] = Utils.copyStackWithAmount(recipes[i - 6].output, Math.min(recipes[i - 6].output.field_77994_a * craftable, 64));
        }
        this.setContainedItems(stack, stored);
    }

    public void reduceInputs(BlueprintCraftingRecipe recipe, ItemStack stack, ItemStack crafted, Container contained) {
        int i;
        ItemStack[] stored = this.getContainedItems(stack);
        ItemStack[] query = new ItemStack[6];
        for (i = 0; i < 6; ++i) {
            query[i] = stored[i];
        }
        recipe.consumeInputs(query, crafted.field_77994_a / recipe.output.field_77994_a);
        for (i = 0; i < 6; ++i) {
            stored[i] = query[i];
        }
        this.setContainedItems(stack, stored);
        if (contained instanceof ContainerModWorkbench) {
            ContainerModWorkbench work = (ContainerModWorkbench)contained;
            if (work.toolInv != null) {
                work.toolInv.stackList = query;
                work.func_75130_a(work.toolInv);
            }
        }
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 6 + BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(stack, "blueprint")).length;
    }

    @Override
    public boolean canTakeFromWorkbench(ItemStack stack) {
        ItemStack[] stored = this.getContainedItems(stack);
        for (int i = 0; i < 6; ++i) {
            if (stored[i] == null) continue;
            return false;
        }
        return true;
    }
}

