/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntitySilo
extends TileEntityMultiblockPart<TileEntitySilo>
implements IEBlockInterfaces.IComparatorOverride {
    public ItemStack identStack;
    public int storageAmount = 0;
    static int maxStorage = 41472;
    boolean lockItem = false;
    private int[] oldComps = new int[6];
    private int masterCompOld;
    private boolean forceUpdate = false;
    private static final int[] size = new int[]{7, 3, 3};
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    IItemHandler insertionHandler = new SiloInventoryHandler(this);

    public TileEntitySilo() {
        super(size);
    }

    public void func_73660_a() {
        if (this.field_174879_c == 4 && !this.field_145850_b.field_72995_K && this.identStack != null && this.storageAmount > 0 && this.field_145850_b.func_175687_A(this.func_174877_v()) > 0 && this.field_145850_b.func_82737_E() % 8L == 0L) {
            this.updateComparatorValuesPart1();
            for (EnumFacing f : EnumFacing.values()) {
                if (f == EnumFacing.UP) continue;
                TileEntity inventory = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
                ItemStack stack = Utils.copyStackWithAmount(this.identStack, 1);
                if ((stack = Utils.insertStackIntoInventory(inventory, stack, f.func_176734_d())) != null) continue;
                --this.storageAmount;
                if (this.storageAmount <= 0) {
                    this.identStack = null;
                }
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
                if (this.storageAmount <= 0) break;
            }
            this.updateComparatorValuesPart2();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.func_74764_b("identStack")) {
            NBTTagCompound t = nbt.func_74775_l("identStack");
            this.identStack = ItemStack.func_77949_a((NBTTagCompound)t);
        } else {
            this.identStack = null;
        }
        this.storageAmount = nbt.func_74762_e("storageAmount");
        this.lockItem = nbt.func_74767_n("lockItem");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.identStack != null) {
            NBTTagCompound t = this.identStack.func_77955_b(new NBTTagCompound());
            nbt.func_74782_a("identStack", (NBTBase)t);
        }
        nbt.func_74768_a("storageAmount", this.storageAmount);
        nbt.func_74757_a("lockItem", this.lockItem);
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c == 0 || this.field_174879_c == 2 || this.field_174879_c == 6 || this.field_174879_c == 8) {
            float zMin;
            float xMax;
            float xMin;
            float f = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c > 2 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 3 == 2 ^ this.facing == EnumFacing.SOUTH) ? 0.75f : (xMin = 0.0f);
            float f2 = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c < 3 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 3 == 0 ^ this.facing == EnumFacing.SOUTH) ? 0.25f : (xMax = 1.0f);
            float f3 = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 3 == 2 ^ this.facing == EnumFacing.EAST : this.field_174879_c < 3 ^ this.facing == EnumFacing.SOUTH) ? 0.75f : (zMin = 0.0f);
            float zMax = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 3 == 0 ^ this.facing == EnumFacing.EAST : this.field_174879_c > 2 ^ this.facing == EnumFacing.SOUTH) ? 0.25f : 1.0f;
            return new float[]{xMin, 0.0f, zMin, xMax, 1.0f, zMax};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public ItemStack getOriginalBlock() {
        return this.field_174879_c == 0 || this.field_174879_c == 2 || this.field_174879_c == 6 || this.field_174879_c == 8 ? new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.FENCE.getMeta()) : new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
    }

    @Override
    public BlockPos getOrigin() {
        return this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]).func_177972_a(this.facing.func_176735_f()).func_177972_a(this.facing.func_176734_d());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.field_174879_c == 4 ? new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 7, 2)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.field_174879_c == 4 || this.field_174879_c == 58) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.field_174879_c == 4 || this.field_174879_c == 58) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getComparatorInputOverride() {
        if (this.field_174879_c == 4) {
            return 15 * this.storageAmount / maxStorage;
        }
        TileEntitySilo master = (TileEntitySilo)this.master();
        if (this.offset[1] >= 1 && this.offset[1] <= 6 && master != null) {
            int layer = this.offset[1] - 1;
            int vol = maxStorage / 6;
            int filled = master.storageAmount - layer * vol;
            int ret = Math.min(15, Math.max(0, 15 * filled / vol));
            return ret;
        }
        return 0;
    }

    private void updateComparatorValuesPart1() {
        int vol = maxStorage / 6;
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            this.oldComps[i] = Math.min(15, Math.max(15 * filled / vol, 0));
        }
        this.masterCompOld = 15 * this.storageAmount / maxStorage;
    }

    private void updateComparatorValuesPart2() {
        int vol = maxStorage / 6;
        if (15 * this.storageAmount / maxStorage != this.masterCompOld) {
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
        }
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now == this.oldComps[i]) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos = this.func_174877_v().func_177982_a(-this.offset[0] + x, -this.offset[1] + i + 1, -this.offset[2] + z);
                    this.field_145850_b.func_175685_c(pos, this.field_145850_b.func_180495_p(pos).func_177230_c());
                }
            }
        }
    }

    public static class SiloInventoryHandler
    implements IItemHandlerModifiable {
        TileEntitySilo silo;

        public SiloInventoryHandler(TileEntitySilo silo) {
            this.silo = silo;
        }

        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? Utils.copyStackWithAmount(this.silo.identStack, Math.min(this.silo.storageAmount, 1)) : Utils.copyStackWithAmount(this.silo.identStack, Math.min(this.silo.storageAmount, 64));
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            stack = stack.func_77946_l();
            TileEntitySilo silo = (TileEntitySilo)this.silo.master();
            int space = maxStorage - silo.storageAmount;
            if (slot != 0 || space < 1 || stack == null || silo.identStack != null && !ItemHandlerHelper.canItemStacksStack((ItemStack)silo.identStack, (ItemStack)stack)) {
                return stack;
            }
            int accepted = Math.min(space, stack.field_77994_a);
            if (!simulate) {
                silo.updateComparatorValuesPart1();
                silo.storageAmount += accepted;
                if (silo.identStack == null) {
                    silo.identStack = stack.func_77946_l();
                }
                silo.func_70296_d();
                silo.markContainingBlockForUpdate(null);
                silo.updateComparatorValuesPart2();
            }
            stack.field_77994_a -= accepted;
            if (stack.field_77994_a < 1) {
                stack = null;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            TileEntitySilo silo = (TileEntitySilo)this.silo.master();
            if (slot != 1 || silo.storageAmount < 1 || amount < 1 || silo.identStack == null) {
                return null;
            }
            ItemStack out = silo.identStack.field_77994_a > amount ? Utils.copyStackWithAmount(silo.identStack, amount) : silo.identStack.func_77946_l();
            if (!simulate) {
                silo.updateComparatorValuesPart1();
                silo.storageAmount -= out.field_77994_a;
                if (silo.storageAmount <= 0 && !silo.lockItem) {
                    silo.identStack = null;
                }
                silo.func_70296_d();
                silo.markContainingBlockForUpdate(null);
                silo.updateComparatorValuesPart2();
            }
            return out;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

