/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityFluidPlacer
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IBlockOverlayText {
    public int[] sideConfig = new int[]{1, 0, 1, 1, 1, 1};
    public FluidTank tank = new FluidTank(4000);
    private int tickCount = 0;
    HashSet<BlockPos> checkedPositions = new HashSet();
    TreeMap<Integer, Queue<BlockPos>> layeredPlacementQueue = new TreeMap();
    HashSet<BlockPos> tempFluids = new HashSet();

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K || this.func_145831_w().func_175687_A(this.func_174877_v()) != 0) {
            return;
        }
        if (this.tickCount % 16 == 0) {
            if (this.tickCount % 512 == 0) {
                this.prepareAreaCheck();
            }
            if (this.tank.getFluidAmount() >= 1000 && this.tank.getFluid().getFluid().getBlock() != null && !this.layeredPlacementQueue.isEmpty()) {
                Queue<BlockPos> lowestLayer = this.layeredPlacementQueue.firstEntry().getValue();
                if (lowestLayer == null || lowestLayer.isEmpty()) {
                    this.layeredPlacementQueue.pollFirstEntry();
                } else {
                    BlockPos targetPos = lowestLayer.poll();
                    IBlockState state = this.func_145831_w().func_180495_p(targetPos);
                    if ((state.func_177230_c().isAir(state, (IBlockAccess)this.func_145831_w(), targetPos) || !state.func_185904_a().func_76220_a()) && !this.isFullFluidBlock(targetPos, state) && FluidUtil.tryPlaceFluid(null, (World)this.func_145831_w(), (FluidStack)this.tank.getFluid(), (BlockPos)targetPos)) {
                        this.tank.drain(1000, true);
                        this.addConnectedSpaces(targetPos);
                        this.handleTempFluids();
                    }
                }
            }
        }
        ++this.tickCount;
    }

    private void prepareAreaCheck() {
        this.checkedPositions.clear();
        this.layeredPlacementQueue.clear();
        this.tempFluids.clear();
        this.addConnectedSpaces(this.func_174877_v());
        this.handleTempFluids();
    }

    private Queue<BlockPos> getQueueForYLevel(int yLevel) {
        Queue<BlockPos> queue = this.layeredPlacementQueue.get(yLevel);
        if (queue == null) {
            queue = new LinkedList<BlockPos>();
            this.layeredPlacementQueue.put(yLevel, queue);
        }
        return queue;
    }

    private void addConnectedSpaces(BlockPos pos) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (facing == EnumFacing.UP || pos == this.func_174877_v() && this.sideConfig[facing.ordinal()] != 1) continue;
            this.addToQueue(pos.func_177972_a(facing));
        }
    }

    private void addToQueue(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() <= 255 && this.checkedPositions.add(pos) && pos.func_177951_i((Vec3i)this.func_174877_v()) < 4096.0 && this.func_145831_w().func_175667_e(pos)) {
            IBlockState state = this.func_145831_w().func_180495_p(pos);
            if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c())) {
                this.tempFluids.add(pos);
            }
            if (!(!state.func_177230_c().isAir(state, (IBlockAccess)this.func_145831_w(), pos) && state.func_185904_a().func_76220_a() || this.isFullFluidBlock(pos, state))) {
                this.getQueueForYLevel(pos.func_177956_o()).add(pos);
            }
        }
    }

    private void handleTempFluids() {
        HashSet<BlockPos> tempFluidsCopy = this.tempFluids;
        this.tempFluids = new HashSet();
        for (BlockPos pos : tempFluidsCopy) {
            this.addConnectedSpaces(pos);
        }
    }

    private boolean isFullFluidBlock(BlockPos pos, IBlockState state) {
        if (state.func_177230_c() instanceof IFluidBlock) {
            return Math.abs(((IFluidBlock)state.func_177230_c()).getFilledPercentage(this.func_145831_w(), pos)) == 1.0f;
        }
        if (state.func_177230_c() instanceof BlockLiquid) {
            return state.func_177230_c().func_176201_c(state) == 0;
        }
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{1, 0, 1, 1, 1, 1};
        }
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        return side >= 0 && side < 6 ? IEEnums.SideConfig.values()[this.sideConfig[side] + 1] : IEEnums.SideConfig.NONE;
    }

    @Override
    public boolean toggleSide(int side, EntityPlayer p) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
        return true;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || this.sideConfig[facing.ordinal()] == 0)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || this.sideConfig[facing.ordinal()] == 0)) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer && Config.IEConfig.colourblindSupport) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.ordinal())];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.func_176734_d().ordinal())];
            return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectFluid." + i), (Object[])new Object[0]), I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectFluid." + j), (Object[])new Object[0])};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

