/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.BlockConveyor;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class ModelConveyor
implements IBakedModel,
IPerspectiveAwareModel {
    static List<BakedQuad> emptyQuads = Lists.newArrayList();
    public static HashMap<String, List<BakedQuad>> modelCache = new HashMap();
    public static ResourceLocation[] rl_casing = new ResourceLocation[]{new ResourceLocation("immersiveengineering", "blocks/conveyor_casing_top"), new ResourceLocation("immersiveengineering", "blocks/conveyor_casing_side"), new ResourceLocation("immersiveengineering", "blocks/conveyor_casing_walls")};
    Set<BakedQuad> quads;
    ConveyorHandler.IConveyorBelt conveyor;
    TextureAtlasSprite tex_particle;
    static HashMap<String, IBakedModel> itemModelCache = new HashMap();
    ItemOverrideList overrideList = new ItemOverrideList(new ArrayList()){

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            String key = ItemNBTHelper.getString(stack, "conveyorType");
            IBakedModel model = itemModelCache.get(key);
            if (model == null) {
                model = new ModelConveyor(ConveyorHandler.getConveyor(new ResourceLocation(key), null));
                itemModelCache.put(key, model);
            }
            return model;
        }
    };
    static HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap = new HashMap();

    public ModelConveyor(ConveyorHandler.IConveyorBelt conveyor) {
        this.conveyor = conveyor;
    }

    public ModelConveyor() {
        this(null);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState blockState, @Nullable EnumFacing side, long rand) {
        boolean[] blArray;
        ConveyorHandler.ConveyorDirection conDir;
        TileEntity tile = null;
        String key = "default";
        EnumFacing facing = EnumFacing.NORTH;
        if (blockState == null) {
            key = this.conveyor != null ? ConveyorHandler.reverseClassRegistry.get(this.conveyor.getClass()).toString() : "immersiveengineering:conveyor";
        } else {
            facing = (EnumFacing)blockState.func_177229_b((IProperty)IEProperties.FACING_ALL);
            if (blockState instanceof IExtendedBlockState) {
                IExtendedBlockState exState = (IExtendedBlockState)blockState;
                if (exState.getUnlistedNames().contains(BlockConveyor.ICONEYOR_PASSTHROUGH)) {
                    this.conveyor = (ConveyorHandler.IConveyorBelt)((IExtendedBlockState)blockState).getValue(BlockConveyor.ICONEYOR_PASSTHROUGH);
                }
                if (exState.getUnlistedNames().contains(IEProperties.TILEENTITY_PASSTHROUGH)) {
                    tile = (TileEntity)((IExtendedBlockState)blockState).getValue(IEProperties.TILEENTITY_PASSTHROUGH);
                }
                if (this.conveyor != null && tile != null) {
                    key = this.conveyor.getModelCacheKey(tile, facing);
                }
            }
        }
        List<Object> cachedQuads = modelCache.get(key);
        if (cachedQuads != null) {
            return Collections.synchronizedList(Lists.newArrayList(cachedQuads));
        }
        cachedQuads = Collections.synchronizedList(Lists.newArrayList());
        Matrix4f facingMatrix = TRSRTransformation.getMatrix((EnumFacing)facing);
        if (this.conveyor != null) {
            facingMatrix = this.conveyor.modifyBaseRotationMatrix(facingMatrix, tile, facing);
        }
        Matrix4 matrix = new Matrix4(facingMatrix);
        ConveyorHandler.ConveyorDirection conveyorDirection = conDir = this.conveyor != null ? this.conveyor.getConveyorDirection() : ConveyorHandler.ConveyorDirection.HORIZONTAL;
        if (this.conveyor != null && tile != null) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = this.conveyor.renderWall(tile, facing, 0);
            blArray = blArray2;
            blArray2[1] = this.conveyor.renderWall(tile, facing, 1);
        } else {
            boolean[] blArray3 = new boolean[2];
            blArray3[0] = true;
            blArray = blArray3;
            blArray3[1] = true;
        }
        boolean[] walls = blArray;
        TextureAtlasSprite tex_conveyor = ClientUtils.mc().func_147117_R().func_174944_f();
        TextureAtlasSprite tex_conveyor_colour = null;
        int colourStripes = -1;
        if (this.conveyor != null) {
            tex_conveyor = ClientUtils.getSprite(tile != null ? (this.conveyor.isActive(tile) ? this.conveyor.getActiveTexture() : this.conveyor.getInactiveTexture()) : this.conveyor.getActiveTexture());
            colourStripes = this.conveyor.getDyeColour();
            if (colourStripes >= 0) {
                tex_conveyor_colour = ClientUtils.getSprite(this.conveyor.getColouredStripesTexture());
            }
        }
        cachedQuads.addAll(ModelConveyor.getBaseConveyor(facing, 1.0f, matrix, conDir, tex_conveyor, walls, new boolean[]{true, true}, tex_conveyor_colour, colourStripes));
        if (this.conveyor != null) {
            cachedQuads = this.conveyor.modifyQuads(cachedQuads, tile, facing);
        }
        modelCache.put(key, cachedQuads);
        return Collections.synchronizedList(Lists.newArrayList(cachedQuads));
    }

    public static Set<BakedQuad> getBaseConveyor(EnumFacing facing, float length, Matrix4 matrix, ConveyorHandler.ConveyorDirection conDir, TextureAtlasSprite tex_conveyor, boolean[] walls, boolean[] corners, TextureAtlasSprite tex_conveyor_colour, int stripeColour) {
        int i;
        int i2;
        int i3;
        LinkedHashSet<BakedQuad> quads = new LinkedHashSet<BakedQuad>();
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0625f, 0.0f, 1.0f - length), new Vector3f(0.0625f, 0.0f, 1.0f), new Vector3f(0.9375f, 0.0f, 1.0f), new Vector3f(0.9375f, 0.0f, 1.0f - length)};
        TextureAtlasSprite tex_casing0 = ClientUtils.getSprite(rl_casing[0]);
        TextureAtlasSprite tex_casing1 = ClientUtils.getSprite(rl_casing[1]);
        TextureAtlasSprite tex_casing2 = ClientUtils.getSprite(rl_casing[2]);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] colourStripes = new float[]{(float)(stripeColour >> 16 & 0xFF) / 255.0f, (float)(stripeColour >> 8 & 0xFF) / 255.0f, (float)(stripeColour & 0xFF) / 255.0f, 1.0f};
        for (int i4 = 0; i4 < 4; ++i4) {
            if (!(i4 == 0 || i4 == 3 ? conDir == ConveyorHandler.ConveyorDirection.UP : conDir == ConveyorHandler.ConveyorDirection.DOWN)) continue;
            vertices[i4].translate(0.0f, length, 0.0f);
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.DOWN, facing), tex_conveyor, new double[]{1.0, 0.0, 15.0, length * 16.0f}, colour, true));
        for (Vector3f v : vertices) {
            v.setX(v.getX() < 0.5f ? 0.0f : 1.0f);
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.DOWN, facing), tex_casing2, new double[]{0.0, 0.0, 16.0, length * 16.0f}, colour, true));
        for (Vector3f v : vertices) {
            v.translate(0.0f, 0.125f, 0.0f);
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), tex_conveyor, new double[]{0.0, length * 16.0f, 16.0, 0.0}, colour, false));
        if (corners[0]) {
            vertices = new Vector3f[]{new Vector3f(0.0f, 0.1875f, 0.9375f), new Vector3f(0.0f, 0.1875f, 1.0f), new Vector3f(1.0f, 0.1875f, 1.0f), new Vector3f(1.0f, 0.1875f, 0.9375f)};
            for (int i5 = 0; i5 < 4; ++i5) {
                vertices[i5].translate(0.0f, i5 == 0 || i5 == 3 ? (conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? length - 0.0625f : 0.0f)) : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? length : 0.0f), 0.0f);
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), tex_casing0, new double[]{0.0, 1.0, 16.0, 0.0}, colour, false));
        }
        if (corners[1]) {
            vertices = new Vector3f[]{new Vector3f(0.0f, 0.1875f, 1.0f - length), new Vector3f(0.0f, 0.1875f, 1.0625f - length), new Vector3f(1.0f, 0.1875f, 1.0625f - length), new Vector3f(1.0f, 0.1875f, 1.0f - length)};
            for (int i6 = 0; i6 < 4; ++i6) {
                vertices[i6].translate(0.0f, i6 == 1 || i6 == 2 ? (conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f)) : (conDir == ConveyorHandler.ConveyorDirection.UP ? length : 0.0f), 0.0f);
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), tex_casing0, new double[]{0.0, 1.0, 16.0, 0.0}, colour, false));
        }
        vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f - length), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.125f, 1.0f), new Vector3f(0.0f, 0.125f, 1.0f - length)};
        for (i3 = 0; i3 < 4; ++i3) {
            if (!(i3 == 0 || i3 == 3 ? conDir == ConveyorHandler.ConveyorDirection.UP : conDir == ConveyorHandler.ConveyorDirection.DOWN)) continue;
            vertices[i3].translate(0.0f, length, 0.0f);
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.WEST, facing), tex_casing1, new double[]{0.0, 0.0, 2.0, length * 16.0f}, colour, false));
        for (i3 = 0; i3 < 4; ++i3) {
            vertices[i3].setY(vertices[i3].getY() + (i3 == 0 || i3 == 1 ? 0.125f : 0.0625f));
        }
        for (i3 = 0; i3 < 4; ++i3) {
            vertices[i3].set(1.0f, vertices[i3].getY() - (i3 == 0 || i3 == 1 ? 0.125f : 0.0625f));
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.EAST, facing), tex_casing1, new double[]{0.0, 0.0, 2.0, length * 16.0f}, colour, true));
        for (i3 = 0; i3 < 4; ++i3) {
            vertices[i3].setY(vertices[i3].getY() + (i3 == 0 || i3 == 1 ? 0.125f : 0.0625f));
        }
        if (corners[0]) {
            vertices = new Vector3f[]{new Vector3f(0.0f, 0.125f, 0.9375f), new Vector3f(0.0f, 0.125f, 1.0f), new Vector3f(0.0f, 0.1875f, 1.0f), new Vector3f(0.0f, 0.1875f, 0.9375f)};
            if (conDir != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                for (i3 = 0; i3 < 4; ++i3) {
                    vertices[i3].translate(0.0f, i3 == 0 || i3 == 3 ? (conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? length - 0.0625f : 0.0f)) : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? length : 0.0f), 0.0f);
                }
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.WEST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, false));
            for (Vector3f v : vertices) {
                v.translate(0.0625f, 0.0f, 0.0f);
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.EAST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, true));
            for (Vector3f v : vertices) {
                v.setX(1.0f);
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.EAST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, true));
            for (Vector3f v : vertices) {
                v.translate(-0.0625f, 0.0f, 0.0f);
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.WEST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, false));
        }
        if (corners[1]) {
            vertices = new Vector3f[]{new Vector3f(0.0f, 0.125f, 1.0f - length), new Vector3f(0.0f, 0.125f, 1.0625f - length), new Vector3f(0.0f, 0.1875f, 1.0625f - length), new Vector3f(0.0f, 0.1875f, 1.0f - length)};
            if (conDir != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                for (int i7 = 0; i7 < 4; ++i7) {
                    vertices[i7].translate(0.0f, i7 == 1 || i7 == 2 ? (conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f)) : (conDir == ConveyorHandler.ConveyorDirection.UP ? length : 0.0f), 0.0f);
                }
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.WEST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, false));
            for (Vector3f v : vertices) {
                v.translate(0.0625f, 0.0f, 0.0f);
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.EAST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, true));
            for (Vector3f v : vertices) {
                v.setX(1.0f);
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.EAST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, true));
            for (Vector3f v : vertices) {
                v.translate(-0.0625f, 0.0f, 0.0f);
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.WEST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, false));
        }
        vertices = new Vector3f[]{new Vector3f(0.0625f, 0.0f, 1.0f - length), new Vector3f(0.0625f, 0.125f, 1.0f - length), new Vector3f(0.9375f, 0.125f, 1.0f - length), new Vector3f(0.9375f, 0.0f, 1.0f - length)};
        if (conDir == ConveyorHandler.ConveyorDirection.UP) {
            for (Vector3f v : vertices) {
                v.translate(0.0f, length, 0.0f);
            }
        }
        double frontUMax = (1.0f - length) * 16.0f;
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_conveyor, new double[]{1.0, frontUMax + 2.0, 15.0, frontUMax}, colour, false));
        for (int i8 = 0; i8 < 4; ++i8) {
            vertices[i8].set(vertices[i8].getX() < 0.5f ? 0.0f : 1.0f, vertices[i8].getY() + (i8 == 1 || i8 == 2 ? 0.0625f : 0.0f));
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_casing2, new double[]{0.0, 3.0, 16.0, 0.0}, colour, false));
        Vector3f[] i8 = vertices;
        int v = i8.length;
        for (int j = 0; j < v; ++j) {
            Vector3f v2 = i8[j];
            v2.translate(0.0f, conDir == ConveyorHandler.ConveyorDirection.UP ? -0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f), 0.0625f);
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_casing2, new double[]{0.0, 3.0, 16.0, 0.0}, colour, true));
        for (i2 = 0; i2 < 4; ++i2) {
            v.setX((v = vertices[i2]).getX() < 0.5f ? 0.0625f : 0.9375f);
            v.setY(v.getY() - (i2 == 1 || i2 == 2 ? 0.0625f : 0.0f));
            if (conDir == ConveyorHandler.ConveyorDirection.UP) {
                v.translate(0.0f, -(length - 0.0625f), 0.0f);
            }
            if (conDir == ConveyorHandler.ConveyorDirection.DOWN) {
                v.translate(0.0f, length - 0.0625f, 0.0f);
            }
            v.translate(0.0f, 0.0f, length - 0.0625f);
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), facing.func_176734_d(), tex_conveyor, new double[]{1.0, 0.0, 15.0, 2.0}, colour, true));
        for (i2 = 0; i2 < 4; ++i2) {
            vertices[i2].set(vertices[i2].getX() < 0.5f ? 0.0f : 1.0f, vertices[i2].getY() + (i2 == 1 || i2 == 2 ? 0.0625f : 0.0f));
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), facing.func_176734_d(), tex_casing2, new double[]{0.0, 0.0, 16.0, 3.0}, colour, true));
        for (Vector3f v2 : vertices) {
            v2.translate(0.0f, conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? -0.0625f : 0.0f), -0.0625f);
        }
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), facing.func_176734_d(), tex_casing2, new double[]{0.0, 0.0, 16.0, 3.0}, colour, false));
        float wallLength = length - 0.125f;
        vertices = new Vector3f[]{new Vector3f(0.0f, 0.1875f, 0.9375f - wallLength), new Vector3f(0.0f, 0.1875f, 0.9375f), new Vector3f(0.0625f, 0.1875f, 0.9375f), new Vector3f(0.0625f, 0.1875f, 0.9375f - wallLength)};
        Vector3f[] vertices2 = new Vector3f[]{new Vector3f(0.0f, 0.125f, 0.9375f - wallLength), new Vector3f(0.0f, 0.125f, 0.9375f), new Vector3f(0.0f, 0.1875f, 0.9375f), new Vector3f(0.0f, 0.1875f, 0.9375f - wallLength)};
        Vector3f[] vertices3 = new Vector3f[]{new Vector3f(0.0625f, 0.125f, 0.9375f - wallLength), new Vector3f(0.0625f, 0.125f, 0.9375f), new Vector3f(0.0625f, 0.1875f, 0.9375f), new Vector3f(0.0625f, 0.1875f, 0.9375f - wallLength)};
        Vector3f[] verticesColour = new Vector3f[]{new Vector3f(0.0f, 0.1876f, corners[1] ? 1.0f - length : 0.9375f - wallLength), new Vector3f(0.0f, 0.1876f, corners[0] ? 1.0f : 0.9375f), new Vector3f(0.0625f, 0.1876f, corners[0] ? 1.0f : 0.9375f), new Vector3f(0.0625f, 0.1876f, corners[1] ? 1.0f - length : 0.9375f - wallLength)};
        for (i = 0; i < 4; ++i) {
            if (conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL) continue;
            float f = i == 0 || i == 3 ? (conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : 0.0625f) : (conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : length - 0.0625f);
            vertices[i].translate(0.0f, f, 0.0f);
            vertices2[i].translate(0.0f, f, 0.0f);
            vertices3[i].translate(0.0f, f, 0.0f);
            verticesColour[i].translate(0.0f, f, 0.0f);
        }
        if (walls[0]) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), tex_casing2, new double[]{0.0, wallLength * 16.0f, 1.0, 1.0}, colour, false));
            if (tex_conveyor_colour != null && stripeColour >= 0) {
                quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, verticesColour), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), tex_conveyor_colour, new double[]{0.0, wallLength * 16.0f, 1.0, 1.0}, colourStripes, false));
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices2), Utils.rotateFacingTowardsDir(EnumFacing.WEST, facing), tex_casing1, new double[]{2.0, wallLength * 16.0f, 3.0, 1.0}, colour, false));
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices3), Utils.rotateFacingTowardsDir(EnumFacing.EAST, facing), tex_casing1, new double[]{2.0, wallLength * 16.0f, 3.0, 1.0}, colour, true));
        }
        for (i = 0; i < 4; ++i) {
            vertices[i].translate(0.9375f, 0.0f, 0.0f);
            vertices2[i].translate(0.9375f, 0.0f, 0.0f);
            vertices3[i].translate(0.9375f, 0.0f, 0.0f);
            verticesColour[i].translate(0.9375f, 0.0f, 0.0f);
        }
        if (walls[1]) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), tex_casing2, new double[]{15.0, wallLength * 16.0f, 16.0, 1.0}, colour, false));
            if (tex_conveyor_colour != null && stripeColour >= 0) {
                quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, verticesColour), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), tex_conveyor_colour, new double[]{15.0, wallLength * 16.0f, 16.0, 1.0}, colourStripes, false));
            }
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices2), Utils.rotateFacingTowardsDir(EnumFacing.WEST, facing), tex_casing1, new double[]{2.0, wallLength * 16.0f, 3.0, 1.0}, colour, false));
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices3), Utils.rotateFacingTowardsDir(EnumFacing.EAST, facing), tex_casing1, new double[]{2.0, wallLength * 16.0f, 3.0, 1.0}, colour, true));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.tex_particle == null) {
            this.tex_particle = ClientUtils.getSprite(this.conveyor != null ? this.conveyor.getInactiveTexture() : new ResourceLocation("immersiveengineering", "blocks/conveyor_off"));
        }
        return this.tex_particle;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Matrix4 matrix = transformationMap.containsKey(cameraTransformType) ? transformationMap.get(cameraTransformType) : new Matrix4();
        return Pair.of((Object)this, (Object)matrix.toMatrix4f());
    }

    static {
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new Matrix4().scale(0.5, 0.5, 0.5).translate(0.0, 0.25, 0.0).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new Matrix4().scale(0.5, 0.5, 0.5).translate(0.0, 0.25, 0.0).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.3125, 0.3125, 0.3125).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.3125, 0.3125, 0.3125).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.GUI, new Matrix4().scale(0.625, 0.625, 0.625).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-20.0), 0.0, 0.0, 1.0).rotate(Math.toRadians(20.0), 1.0, 0.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.FIXED, new Matrix4().scale(0.625, 0.625, 0.625).rotate(Math.PI, 0.0, 1.0, 0.0).translate(0.0, 0.0, 0.3125));
        transformationMap.put(ItemCameraTransforms.TransformType.GROUND, new Matrix4().scale(0.25, 0.25, 0.25));
    }
}

