/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.util.network.MessageShaderManual;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManual;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class ManualPageShader
extends ManualPages {
    final ShaderRegistry.ShaderRegistryEntry shader;
    ItemStack shaderItem;
    ItemStack[] exampleItems;
    IngredientStack replicationCost;
    int example = 0;
    boolean unlocked;

    public ManualPageShader(ManualInstance manual, ShaderRegistry.ShaderRegistryEntry shader) {
        super(manual, "");
        this.shader = shader;
    }

    @Override
    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        EntityPlayerSP player = ManualUtils.mc().field_71439_g;
        String username = player.func_70005_c_();
        this.unlocked = ShaderRegistry.receivedShaders.get((Object)username).contains(this.shader.getName());
        this.shaderItem = new ItemStack(ShaderRegistry.itemShader);
        this.shaderItem.func_77982_d(new NBTTagCompound());
        this.shaderItem.func_77978_p().func_74778_a("shader_name", this.shader.getName());
        this.replicationCost = this.shader.replicationCost;
        if (this.unlocked) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack is : ShaderRegistry.itemExamples) {
                ItemStack s;
                CapabilityShader.ShaderWrapper wrapper;
                if (is == null || !is.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) || (wrapper = (CapabilityShader.ShaderWrapper)(s = is.func_77946_l()).getCapability(CapabilityShader.SHADER_CAPABILITY, null)) == null) continue;
                wrapper.setShaderItem(this.shaderItem);
                list.add(s);
            }
            this.exampleItems = list.toArray(new ItemStack[list.size()]);
            this.example = 0;
            if (this.exampleItems.length > 1) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 100, x + 50, y, 10, 16, 0));
                pageButtons.add(new GuiButtonManualNavigation(gui, 101, x + 100, y, 10, 16, 1));
            }
        } else {
            this.exampleItems = null;
        }
        this.text = "\u00c2\u00a7lRarity: \u00c2\u00a7r " + this.shader.rarity.field_77934_f;
        if (this.unlocked) {
            String details;
            String set = this.shader.info_set == null || this.shader.info_set.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.set.%s", this.shader.info_set);
            String reference = this.shader.info_reference == null || this.shader.info_reference.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.reference.%s", this.shader.info_reference);
            String string = details = this.shader.info_details == null || this.shader.info_details.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.details.%s", this.shader.info_details);
            if (set != null) {
                this.text = this.text + "<br><br>" + I18n.func_135052_a((String)"desc.immersiveengineering.info.shader.set", (Object[])new Object[0]) + " " + set;
            }
            if (reference != null) {
                this.text = this.text + "<br><br>" + I18n.func_135052_a((String)"desc.immersiveengineering.info.shader.reference", (Object[])new Object[0]) + "<br>" + reference;
            }
            if (details != null) {
                this.text = this.text + "<br><br>" + I18n.func_135052_a((String)"desc.immersiveengineering.info.shader.details", (Object[])new Object[0]) + "<br>" + details;
            }
            String cost = Integer.toString(this.replicationCost.inputSize);
            if (!ApiUtils.hasPlayerIngredient((EntityPlayer)gui.field_146297_k.field_71439_g, this.replicationCost) && !gui.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                cost = TextFormatting.RED + cost;
            }
            pageButtons.add(new GuiButtonManual(gui, 102, x + 50, y + 138, 70, 12, TextFormatting.BOLD + I18n.func_135052_a((String)"ie.manual.entry.shaderList.order", (Object[])new Object[0]) + " " + cost + "x   ").setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
        } else {
            this.text = this.text + "<br><br>" + I18n.func_135052_a((String)"ie.manual.entry.shaderList.noInfo", (Object[])new Object[0]);
            if (player.field_71075_bZ.field_75098_d) {
                pageButtons.add(new GuiButtonManual(gui, 103, x + 10, y + 80, 100, 16, I18n.func_135052_a((String)"ie.manual.entry.shaderList.unlock", (Object[])new Object[0])).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
            }
        }
        super.initPage(gui, x, y, pageButtons);
    }

    @Override
    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        float scale = 2.0f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        boolean examples = this.exampleItems != null && this.exampleItems.length > 0;
        ManualUtils.renderItem().func_180450_b(this.shaderItem, (int)((float)(x + 10 + (examples ? 0 : 34)) / scale), (int)((float)(y - 8) / scale));
        if (examples && this.example >= 0 && this.example < this.exampleItems.length) {
            ManualUtils.renderItem().func_180450_b(this.exampleItems[this.example], (int)((float)(x + 63) / scale), (int)((float)(y - 8) / scale));
        }
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        if (this.unlocked) {
            ManualUtils.renderItem().func_180450_b(this.replicationCost.getRandomizedExampleStack(gui.field_146297_k.field_71439_g.field_70173_aa), x + 102, y + 136);
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        this.manual.fontRenderer.func_78264_a(true);
        String name = "\u00c2\u00a7l" + this.shader.getName();
        int w = this.manual.fontRenderer.func_78256_a(name);
        this.manual.fontRenderer.func_175065_a(name, (float)(x + 60 - w / 2), (float)(y + 24), this.manual.getTextColour(), false);
        if (this.localizedText != null && !this.localizedText.isEmpty()) {
            this.manual.fontRenderer.func_78279_b(this.localizedText, x, y + 38, 120, this.manual.getTextColour());
        }
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    public void buttonPressed(GuiManual gui, GuiButton button) {
        if (button.field_146127_k == 100) {
            --this.example;
            if (this.example < 0) {
                this.example = this.exampleItems.length - 1;
            }
        } else if (button.field_146127_k == 101) {
            this.example = (this.example + 1) % this.exampleItems.length;
        } else if (button.field_146127_k == 102) {
            if (ApiUtils.hasPlayerIngredient((EntityPlayer)gui.field_146297_k.field_71439_g, this.replicationCost) || gui.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageShaderManual(MessageShaderManual.MessageType.SPAWN, gui.field_146297_k.field_71439_g.func_70005_c_(), this.shader.getName()));
            }
            gui.func_73866_w_();
        } else if (button.field_146127_k == 103) {
            String player = ManualUtils.mc().field_71439_g.func_70005_c_();
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageShaderManual(MessageShaderManual.MessageType.UNLOCK, player, this.shader.getName()));
            ShaderRegistry.receivedShaders.put((Object)player, (Object)this.shader.getName());
            gui.func_73866_w_();
        }
        super.buttonPressed(gui, button);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }
}

