/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.immersiveflux;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;

public class FluxStorageAdvanced
extends FluxStorage {
    int averageInsertion = 0;
    int averageExtraction = 0;
    double averageDecayFactor = 0.5;

    public FluxStorageAdvanced(int capacity, int limitReceive, int limitExtract) {
        super(capacity, limitReceive, limitExtract);
    }

    public FluxStorageAdvanced(int capacity, int limitTransfer) {
        super(capacity, limitTransfer);
    }

    public FluxStorageAdvanced(int capacity) {
        super(capacity, capacity, capacity);
    }

    @Override
    public int receiveEnergy(int energy, boolean simulate) {
        int received = super.receiveEnergy(energy, simulate);
        if (!simulate) {
            this.averageInsertion = (int)Math.round((double)this.averageInsertion * this.averageDecayFactor + (double)received * (1.0 - this.averageDecayFactor));
        }
        return received;
    }

    @Override
    public int extractEnergy(int energy, boolean simulate) {
        int extracted = super.extractEnergy(energy, simulate);
        if (!simulate) {
            this.averageExtraction = (int)Math.round((double)this.averageExtraction * this.averageDecayFactor + (double)extracted * (1.0 - this.averageDecayFactor));
        }
        return extracted;
    }

    public int getAverageInsertion() {
        return this.averageInsertion;
    }

    public int getAverageExtraction() {
        return this.averageExtraction;
    }

    public FluxStorageAdvanced setDecayFactor(double factor) {
        this.averageDecayFactor = factor;
        return this;
    }
}

