/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final IngredientStack input;
    public final FluidStack fluidOutput;
    public final ItemStack itemOutput;
    public static ArrayList<SqueezerRecipe> recipeList = new ArrayList();

    public SqueezerRecipe(FluidStack fluidOutput, ItemStack itemOutput, Object input, int energy) {
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.input = ApiUtils.createIngredientStack(input);
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor(80.0f * timeModifier);
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.input});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        this.outputList = Lists.newArrayList((Object[])new ItemStack[]{this.itemOutput});
    }

    public SqueezerRecipe setInputSize(int size) {
        this.input.inputSize = size;
        return this;
    }

    public static SqueezerRecipe addRecipe(FluidStack fluidOutput, ItemStack itemOutput, Object input, int energy) {
        SqueezerRecipe r = new SqueezerRecipe(fluidOutput, itemOutput, input, energy);
        recipeList.add(r);
        return r;
    }

    public static SqueezerRecipe findRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        for (SqueezerRecipe recipe : recipeList) {
            if (!recipe.input.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static SqueezerRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack input = IngredientStack.readFromNBT(nbt.func_74775_l("input"));
        for (SqueezerRecipe recipe : recipeList) {
            if (!recipe.input.equals(input)) continue;
            return recipe;
        }
        return null;
    }

    public static Map<String, Integer> getFluidValuesSorted(Fluid f, boolean inverse) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (SqueezerRecipe recipe : recipeList) {
            if (recipe.fluidOutput == null || recipe.fluidOutput.getFluid() != f) continue;
            ItemStack is = recipe.input.getExampleStack();
            map.put(is.func_82833_r(), recipe.fluidOutput.amount);
        }
        return ApiUtils.sortMap(map, inverse);
    }
}

