/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class IEApi {
    public static List<String> modPreference;
    public static HashMap<String, ItemStack> oreOutputPreference;
    public static int revolverTextureSheetID;
    public static HashMap<String, Integer[]> prefixToIngotMap;
    public static Potion[] potions;
    public static List<Runnable> renderCacheClearers;
    public static List<Predicate<ItemStack>> forbiddenInCrates;

    public static ItemStack getPreferredOreStack(String oreName) {
        if (!oreOutputPreference.containsKey(oreName)) {
            ItemStack preferredStack = ApiUtils.isExistingOreName(oreName) ? IEApi.getPreferredStackbyMod(OreDictionary.getOres((String)oreName)) : null;
            oreOutputPreference.put(oreName, preferredStack);
            return preferredStack;
        }
        ItemStack s = oreOutputPreference.get(oreName);
        return s != null ? s.func_77946_l() : null;
    }

    public static ItemStack getPreferredStackbyMod(List<ItemStack> list) {
        ItemStack preferredStack = null;
        int lastPref = -1;
        for (ItemStack stack : list) {
            int idx;
            ResourceLocation rl;
            if (stack == null || stack.func_77973_b() == null || (rl = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)stack.func_77973_b())) == null) continue;
            String modId = rl.func_110624_b();
            int n = idx = modId == null || modId.isEmpty() ? -1 : modPreference.indexOf(modId);
            if (preferredStack != null && (idx < 0 || lastPref >= 0 && idx >= lastPref)) continue;
            preferredStack = stack;
            lastPref = idx;
        }
        return preferredStack != null ? preferredStack.func_77946_l() : null;
    }

    public static boolean isAllowedInCrate(ItemStack stack) {
        for (Predicate<ItemStack> check : forbiddenInCrates) {
            if (!check.test(stack)) continue;
            return false;
        }
        return true;
    }

    static {
        oreOutputPreference = new HashMap();
        prefixToIngotMap = new HashMap();
        renderCacheClearers = new ArrayList<Runnable>();
        forbiddenInCrates = new ArrayList<Predicate<ItemStack>>();
    }
}

