/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import com.brandon3055.brandonscore.client.gui.effects.GuiEffect;
import com.brandon3055.brandonscore.client.gui.effects.GuiEffectRenderer;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.client.gui.GuiFusionCraftingCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.integration.jei.DEJEIPlugin;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FusionRecipeWrapper
extends BlankRecipeWrapper {
    private GuiEffectRenderer effectRenderer = new GuiEffectRenderer();
    public final IFusionRecipe recipe;
    private final List inputs = new LinkedList();
    private int timeout = 0;
    private int xSize = 164;
    private int ySize = 111;
    private int lastTick = 0;
    private ITickTimer timer;

    public FusionRecipeWrapper(IFusionRecipe recipe) {
        this.recipe = recipe;
        this.inputs.add(recipe.getRecipeCatalyst());
        for (Object o : recipe.getRecipeIngredients()) {
            if (o instanceof Item) {
                this.inputs.add(new ItemStack((Item)o));
                continue;
            }
            if (o instanceof Block) {
                this.inputs.add(new ItemStack((Block)o));
                continue;
            }
            this.inputs.add(o);
        }
        this.timer = DEJEIPlugin.jeiHelpers.getGuiHelper().createTickTimer(1000000, 1000000, false);
    }

    public void getIngredients(IIngredients ingredients) {
        List list = DEJEIPlugin.jeiHelpers.getStackHelper().expandRecipeItemStackInputs(this.inputs);
        ingredients.setInputLists(ItemStack.class, list);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getRecipeOutput(null));
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.timeout = 0;
        if (minecraft.field_71466_p != null) {
            GuiHelper.drawCenteredString((FontRenderer)minecraft.field_71466_p, (String)I18n.func_135052_a((String)("gui.jeiFusion.tier." + this.recipe.getRecipeTier()), (Object[])new Object[0]), (int)(this.xSize / 2), (int)5, (int)0xFF6600, (boolean)false);
            GuiHelper.drawCenteredString((FontRenderer)minecraft.field_71466_p, (String)I18n.func_135052_a((String)"generic.de.energyCost.txt", (Object[])new Object[0]), (int)(this.xSize / 2), (int)(this.ySize - 20), (int)0x4444FF, (boolean)false);
            GuiHelper.drawCenteredString((FontRenderer)minecraft.field_71466_p, (String)(Utils.addCommas((int)(this.recipe.getEnergyCost() * this.recipe.getRecipeIngredients().size())) + "RF"), (int)(this.xSize / 2), (int)(this.ySize - 10), (int)0x44AAFF, (boolean)false);
        }
    }

    public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
        if (ClientEventHandler.elapsedTicks != this.lastTick) {
            this.lastTick = ClientEventHandler.elapsedTicks;
            this.tick();
        }
        this.effectRenderer.renderEffects(minecraft.func_184121_ak());
        GuiHelper.drawBorderedRect((int)(this.xSize / 2 - 10), (int)22, (int)20, (int)66, (int)1, (int)0x40FFFFFF, (int)-16711681);
        if (this.recipe.getRecipeIngredients().size() > 16) {
            GuiHelper.drawBorderedRect((int)1, (int)6, (int)18, (int)100, (int)1, (int)0x40FFFFFF, (int)-5635841);
            GuiHelper.drawBorderedRect((int)18, (int)6, (int)18, (int)100, (int)1, (int)0x40FFFFFF, (int)-5635841);
            GuiHelper.drawBorderedRect((int)(this.xSize - 20), (int)6, (int)18, (int)100, (int)1, (int)0x40FFFFFF, (int)-5635841);
            GuiHelper.drawBorderedRect((int)(this.xSize - 37), (int)6, (int)18, (int)100, (int)1, (int)0x40FFFFFF, (int)-5635841);
        } else {
            GuiHelper.drawBorderedRect((int)8, (int)6, (int)20, (int)100, (int)1, (int)0x40FFFFFF, (int)-5635841);
            GuiHelper.drawBorderedRect((int)(this.xSize - 28), (int)6, (int)20, (int)100, (int)1, (int)0x40FFFFFF, (int)-5635841);
        }
    }

    public void tick() {
        this.effectRenderer.updateEffects();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            List ingredients = this.recipe.getRecipeIngredients();
            int centerX = this.xSize / 2;
            int centerY = this.ySize / 2;
            for (int i = 0; i < ingredients.size(); ++i) {
                int yPos;
                int sideIndex;
                int ySize;
                int xPos;
                boolean isLeft = i % 2 == 0;
                boolean isOdd = ingredients.size() % 2 == 1;
                int sideCount = ingredients.size() / 2;
                if (isOdd && !isLeft) {
                    --sideCount;
                }
                if (isLeft) {
                    xPos = centerX - 65;
                    ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                    sideIndex = i / 2;
                    if (!(sideCount > 1 || isOdd && ingredients.size() != 1)) {
                        sideIndex = 1;
                        ySize = 40;
                    }
                    yPos = centerY - 40 + sideIndex * ySize;
                } else {
                    xPos = centerX + 65;
                    ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                    sideIndex = i / 2;
                    if (isOdd) {
                        ++sideCount;
                    }
                    if (sideCount <= 1) {
                        sideIndex = 1;
                        ySize = 40;
                    }
                    yPos = centerY - 40 + sideIndex * ySize;
                }
                if (world.field_73012_v.nextInt(10) != 0) continue;
                xPos = (int)((double)xPos + (-8.0 + world.field_73012_v.nextDouble() * 16.0));
                yPos = (int)((double)yPos + (-8.0 + world.field_73012_v.nextDouble() * 16.0));
                double ty = (double)centerY + (-20.0 + world.field_73012_v.nextDouble() * 40.0);
                this.effectRenderer.addEffect((GuiEffect)new GuiFusionCraftingCore.EnergyEffect((World)Minecraft.func_71410_x().field_71441_e, xPos, yPos, centerX, ty, 0));
            }
            double xPos = (double)(centerX - 8) + world.field_73012_v.nextDouble() * 16.0;
            double yTop = 27.0 + world.field_73012_v.nextDouble() * 16.0;
            this.effectRenderer.addEffect((GuiEffect)new GuiFusionCraftingCore.EnergyEffect((World)Minecraft.func_71410_x().field_71441_e, xPos, yTop, centerX, 78.0, 1));
            this.effectRenderer.updateEffects();
        } else {
            this.effectRenderer.clearEffects();
        }
    }
}

