/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.state.GlStateManagerHelper;
import codechicken.lib.vec.Cuboid6;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.ICrystalLink;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BinderHandler {
    public static Map<AxisAlignedBB, CCModel> modelCache = new HashMap<AxisAlignedBB, CCModel>();

    public static boolean onBinderUse(EntityPlayer player, EnumHand hand, World world, BlockPos blockClicked, @Nonnull ItemStack binder, EnumFacing sideClicked) {
        TileEntity tile = world.func_175625_s(blockClicked);
        boolean isBound = BinderHandler.isBound(binder);
        if (tile instanceof ICrystalLink && player.func_70093_af()) {
            BinderHandler.bind(binder, blockClicked);
            if (world.field_72995_K) {
                ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.posSavedToTool.info", (TextFormatting)TextFormatting.GREEN, (int)-442611624, (Object[])new Object[0]);
                player.func_184609_a(hand);
            }
            return true;
        }
        if (tile instanceof ICrystalLink && !isBound) {
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.toolNotBound.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            return true;
        }
        if (isBound) {
            BlockPos boundLinkable = BinderHandler.getBound(binder);
            if (boundLinkable.equals((Object)blockClicked)) {
                ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.linkToSelf.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
                return true;
            }
            TileEntity boundTile = world.func_175625_s(boundLinkable);
            if (boundTile instanceof ICrystalLink) {
                if (((ICrystalLink)boundTile).binderUsed(player, blockClicked, sideClicked)) {
                    player.func_184609_a(hand);
                }
            } else {
                ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.boundToInvalid.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    private static boolean isBound(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("draconicevolution:binder", 11);
    }

    private static void bind(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.getCompound((ItemStack)stack).func_74783_a("draconicevolution:binder", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
    }

    private static BlockPos getBound(ItemStack stack) {
        int[] intArray = stack.func_77978_p().func_74759_k("draconicevolution:binder");
        return new BlockPos(intArray[0], intArray[1], intArray[2]);
    }

    public static boolean clearBinder(EntityPlayer player, @Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("draconicevolution:binder")) {
            stack.func_77978_p().func_82580_o("draconicevolution:binder");
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.posCleared.info", (TextFormatting)TextFormatting.GREEN, (int)-442611624, (Object[])new Object[0]);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderWorldOverlay(EntityPlayerSP player, World world, ItemStack stack, Minecraft mc, float partialTicks) {
        if (!BinderHandler.isBound(stack)) {
            return;
        }
        BlockPos pos = BinderHandler.getBound(stack);
        boolean valid = world.func_175625_s(pos) instanceof ICrystalLink;
        double offsetX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double offsetY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double offsetZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        IBlockState state = world.func_180495_p(pos);
        CCModel model = BinderHandler.modelForAABB(state.func_177230_c().func_185496_a(state, (IBlockAccess)world, pos));
        GlStateManager.func_179094_E();
        GlStateManagerHelper.pushState();
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - offsetX), (double)((double)pos.func_177956_o() - offsetY), (double)((double)pos.func_177952_p() - offsetZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)(valid ? 0.0f : 1.0f), (float)(valid ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
        GlStateManager.func_179097_i();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(7, DefaultVertexFormats.field_181705_e);
        model.render(ccrs, new IVertexOperation[0]);
        ccrs.draw();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManagerHelper.popState();
        GlStateManager.func_179121_F();
    }

    private static CCModel modelForAABB(AxisAlignedBB aabb) {
        if (!modelCache.containsKey(aabb)) {
            modelCache.put(aabb, CCModel.newModel((int)7, (int)24).generateBlock(0, new Cuboid6(aabb)));
        }
        return modelCache.get(aabb);
    }
}

