/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.render.state.GlStateManagerHelper;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class CrystalFXIO
extends CrystalGLFXBase<TileCrystalBase> {
    private long rSeed = 0L;
    private static final FXHandler BASIC_HANDLER = new FXHandler("textures/particle/energy_beam_basic.png");
    private static final FXHandler WYVERN_HANDLER = new FXHandler("textures/particle/energy_beam_wyvern.png");
    private static final FXHandler DRACONIC_HANDLER = new FXHandler("textures/particle/energy_beam_draconic.png");

    public CrystalFXIO(World worldIn, TileCrystalBase tile) {
        super(worldIn, tile);
        this.field_94054_b = 3 + tile.getTier();
        this.field_70546_d = worldIn.field_73012_v.nextInt(1024);
        this.rSeed = tile.func_174877_v().func_177986_g();
    }

    public int func_70537_b() {
        return 2;
    }

    @Override
    public void func_189213_a() {
        if (this.ticksTillDeath-- <= 0) {
            this.func_187112_i();
        }
        float[] r = new float[]{0.0f, 0.8f, 1.0f};
        float[] g = new float[]{0.8f, 0.1f, 0.7f};
        float[] b = new float[]{1.0f, 1.0f, 0.2f};
        this.field_70552_h = r[this.tile.getTier()];
        this.field_70553_i = g[this.tile.getTier()];
        this.field_70551_j = b[this.tile.getTier()];
    }

    @Override
    public void func_180434_a(VertexBuffer vertexbuffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!this.renderEnabled) {
            return;
        }
        float renderX = (float)(this.field_187126_f - field_70556_an);
        float renderY = (float)(this.field_187127_g - field_70554_ao);
        float renderZ = (float)(this.field_187128_h - field_70555_ap);
        this.field_70544_f = 0.2f;
        vertexbuffer.func_181662_b((double)(renderX - rotationX * this.field_70544_f - rotationXY * this.field_70544_f), (double)(renderY - rotationZ * this.field_70544_f), (double)(renderZ - rotationYZ * this.field_70544_f - rotationXZ * this.field_70544_f)).func_187315_a(0.5, 0.5).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX - rotationX * this.field_70544_f + rotationXY * this.field_70544_f), (double)(renderY + rotationZ * this.field_70544_f), (double)(renderZ - rotationYZ * this.field_70544_f + rotationXZ * this.field_70544_f)).func_187315_a(0.5, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX + rotationX * this.field_70544_f + rotationXY * this.field_70544_f), (double)(renderY + rotationZ * this.field_70544_f), (double)(renderZ + rotationYZ * this.field_70544_f + rotationXZ * this.field_70544_f)).func_187315_a(0.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX + rotationX * this.field_70544_f - rotationXY * this.field_70544_f), (double)(renderY - rotationZ * this.field_70544_f), (double)(renderZ + rotationYZ * this.field_70544_f - rotationXZ * this.field_70544_f)).func_187315_a(0.0, 0.5).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_181675_d();
    }

    public IGLFXHandler getFXHandler() {
        return this.tile.getTier() == 0 ? BASIC_HANDLER : (this.tile.getTier() == 1 ? WYVERN_HANDLER : DRACONIC_HANDLER);
    }

    public static class FXHandler
    implements IGLFXHandler {
        private String texture;

        public FXHandler(String texture) {
            this.texture = texture;
        }

        public void preDraw(int layer, VertexBuffer vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManagerHelper.pushState();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179129_p();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            ResourceHelperDE.bindTexture(this.texture);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        }

        public void postDraw(int layer, VertexBuffer vertexbuffer, Tessellator tessellator) {
            tessellator.func_78381_a();
            GlStateManagerHelper.popState();
        }
    }
}

