/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiListEntry;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiConfig;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCSplitContainer;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import org.w3c.dom.Element;

public abstract class DisplayComponentBase
extends MGuiListEntry
implements IMGuiListener {
    private GuiModWiki modWiki;
    protected String componentType;
    public TreeBranchRoot branch;
    public Element element;
    public EnumAlignment alignment = EnumAlignment.CENTER;
    public boolean shadow;
    private int colour = 0xFFFFFF;
    public boolean colourSet = false;
    public int posIndex = 0;
    public DCSplitContainer container = null;
    public boolean requiresSave = false;
    public boolean isBeingEdited = false;
    public int saveTimer = 0;
    public static final String ATTRIB_ALIGNMENT = "alignment";
    public static final String ATTRIB_SHADOW = "shadow";
    public static final String ATTRIB_COLOUR = "colour";

    public DisplayComponentBase(GuiModWiki modWiki, String componentType, TreeBranchRoot branch) {
        super((IModularGui)modWiki);
        this.modWiki = modWiki;
        this.componentType = componentType;
        this.branch = branch;
    }

    public int getEntryHeight() {
        return this.ySize;
    }

    public void moveEntry(int newXPos, int newYPos) {
        int moveX = newXPos - this.xPos;
        int moveY = newYPos - this.yPos;
        this.moveBy(moveX, moveY);
    }

    public void setXSize(int xSize) {
        this.xSize = xSize;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (WikiConfig.editMode && this.isMouseOver(mouseX, mouseY) && this.modWiki.contentWindow.editingComponent != this) {
            this.modWiki.contentWindow.setEditingComponent(this);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = new LinkedList<MGuiElementBase>();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "MOVE_UP", 0, 0, 10, 12, "\u25b2"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Move Element Up"}));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "MOVE_DOWN", 0, 0, 10, 12, "\u25bc"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Move Element Down"}));
        return list;
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return super.keyTyped(typedChar, keyCode);
    }

    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("MOVE_UP")) {
            int listIndex = this.branch.branchContent.indexOf((Object)this);
            if (listIndex <= 0) {
                return;
            }
            DisplayComponentBase compAbove = this.branch.branchContent.get(listIndex - 1);
            this.element.setAttribute("index", String.valueOf(compAbove.posIndex));
            compAbove.element.setAttribute("index", String.valueOf(this.posIndex));
            try {
                this.branch.save();
                this.branch.loadBranchContent();
                this.modWiki.wikiDataTree.setActiveBranch(this.branch);
                this.modWiki.contentWindow.setEditingComponent(this.branch.branchContent.get(listIndex - 1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("MOVE_DOWN")) {
            int listIndex = this.branch.branchContent.indexOf((Object)this);
            if (listIndex + 1 >= this.branch.branchContent.size()) {
                return;
            }
            DisplayComponentBase compBellow = this.branch.branchContent.get(listIndex + 1);
            this.element.setAttribute("index", String.valueOf(compBellow.posIndex));
            compBellow.element.setAttribute("index", String.valueOf(this.posIndex));
            try {
                this.branch.save();
                this.branch.loadBranchContent();
                this.modWiki.wikiDataTree.setActiveBranch(this.branch);
                this.modWiki.contentWindow.setEditingComponent(this.branch.branchContent.get(listIndex + 1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("TOGGLE_ALIGN")) {
            this.alignment = this.alignment == EnumAlignment.LEFT ? EnumAlignment.CENTER : (this.alignment == EnumAlignment.CENTER ? EnumAlignment.RIGHT : EnumAlignment.LEFT);
            this.element.setAttribute(ATTRIB_ALIGNMENT, this.alignment.name());
            this.save();
        }
    }

    public void save() {
        try {
            DisplayComponentBase comp;
            int index = this.branch.branchContent.indexOf((Object)this);
            if (this.container != null) {
                index = this.branch.branchContent.indexOf((Object)this.container);
            }
            this.branch.save();
            this.branch.loadBranchContent();
            this.modWiki.wikiDataTree.setActiveBranch(this.branch);
            DisplayComponentBase displayComponentBase = comp = index >= 0 && index < this.branch.branchContent.size() ? this.branch.branchContent.get(index) : null;
            if (comp instanceof DCSplitContainer && this.container != null) {
                String side = this.element.getAttribute("splitSide");
                this.modWiki.contentWindow.setEditingComponent(side.equals("LEFT") ? ((DCSplitContainer)comp).componentLeft : (side.equals("RIGHT") ? ((DCSplitContainer)comp).componentRight : null));
            } else {
                this.modWiki.contentWindow.setEditingComponent(comp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (WikiConfig.editMode && WikiConfig.drawEditInfo) {
            this.drawBorderedRect(this.xPos, this.yPos, this.xSize, this.ySize, 0.5, 0, this.modWiki.contentWindow.editingComponent == this ? -16711936 : -65536);
            if (this.isMouseOver(mouseX, mouseY)) {
                int x = this.list.xPos;
                int y = this.list.yPos - 10;
                this.zOffset += 200.0;
                String s = "Content Type: <" + this.componentType + "> Click to edit";
                this.drawColouredRect(x, y, this.fontRenderer.func_78256_a(s) + 2, 10.0, -16777216);
                this.drawString(this.fontRenderer, s, x + 1, y + 1, 0xFF0000);
                this.zOffset -= 200.0;
            }
        }
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public void loadFromXML(Element element) {
        this.element = element;
        try {
            this.posIndex = Integer.parseInt(element.getAttribute("index"));
        }
        catch (Exception e) {
            LogHelper.error("Failed to load component index in: " + this.branch.branchID + " Attempting to insert in the correct location based on document order.");
            e.printStackTrace();
            this.posIndex = this.branch.branchContent.size();
        }
        if (element.hasAttribute(ATTRIB_ALIGNMENT)) {
            String align = element.getAttribute(ATTRIB_ALIGNMENT);
            this.alignment = EnumAlignment.valueOf((String)align.toUpperCase());
        }
        if (element.hasAttribute(ATTRIB_SHADOW)) {
            this.shadow = Boolean.parseBoolean(element.getAttribute(ATTRIB_SHADOW));
        }
        if (element.hasAttribute(ATTRIB_COLOUR) && element.getAttribute(ATTRIB_COLOUR).length() > 0) {
            try {
                this.colour = Integer.parseInt(element.getAttribute(ATTRIB_COLOUR), 16);
                this.colourSet = true;
            }
            catch (Exception e) {
                LogHelper.error("Error reading element colour: " + element + " In:" + this.branch.branchID);
                e.printStackTrace();
            }
        }
    }

    public abstract void onCreated();

    public boolean onUpdate() {
        if (this.saveTimer > 0) {
            --this.saveTimer;
            if (this.saveTimer <= 0) {
                this.requiresSave = false;
                this.save();
                return true;
            }
        }
        return super.onUpdate();
    }

    public int getColour() {
        return this.colourSet ? this.colour : WikiConfig.TEXT_COLOUR;
    }

    public void setColour(int colour) {
        this.colour = colour;
        this.colourSet = true;
    }
}

