/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.rendering;

import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.draconicevolution.api.ICrystalLink;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBeam;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class ENetFXHandlerClient
extends ENetFXHandler {
    protected CrystalGLFXBase staticFX;
    protected LinkedList<CrystalGLFXBase> beamFXList = new LinkedList();

    public ENetFXHandlerClient(TileCrystalBase tile) {
        super(tile);
    }

    @Override
    public void update() {
        if (this.staticFX == null || !this.staticFX.func_187113_k()) {
            this.staticFX = this.tile.createStaticFX();
            BCEffectHandler.spawnGLParticle((IGLFXHandler)this.staticFX.getFXHandler(), (BCParticle)this.staticFX);
        }
        this.staticFX.updateFX(0.5f);
        boolean bl = this.staticFX.renderEnabled = this.renderCooldown > 0;
        if (this.renderCooldown > 0) {
            --this.renderCooldown;
        }
        boolean requiresUpdate = false;
        for (CrystalGLFXBase beam : this.beamFXList) {
            if (!beam.func_187113_k()) {
                requiresUpdate = true;
            }
            if (this.tile.flowRates.size() <= this.beamFXList.indexOf((Object)beam)) continue;
            beam.updateFX((float)(this.tile.flowRates.get((byte)this.beamFXList.indexOf((Object)beam)) & 0xFF) / 255.0f);
        }
        if (requiresUpdate || this.tile.getLinks().size() != this.beamFXList.size()) {
            this.reloadConnections();
        }
    }

    @Override
    public void updateReceived(CrystalUpdateBatcher.BatchedCrystalUpdate update) {
        this.tile.modifyEnergyStored(update.crystalCapacity - this.tile.getEnergyStored());
        Map<Byte, Byte> flowMap = update.indexToFlowMap;
        for (byte index = 0; index < this.tile.flowRates.size(); index = (byte)(index + 1)) {
            if (flowMap.containsKey(index)) continue;
            flowMap.put(index, this.tile.flowRates.get(index));
        }
        this.tile.flowRates.clear();
        for (byte i = 0; i < flowMap.size(); i = (byte)(i + 1)) {
            if (!flowMap.containsKey(i)) continue;
            this.tile.flowRates.add(flowMap.get(i));
        }
    }

    @Override
    public void reloadConnections() {
        this.beamFXList.clear();
        for (BlockPos pos : this.tile.getLinks()) {
            TileEntity target = this.tile.func_145831_w().func_175625_s(pos);
            if (!(target instanceof ICrystalLink)) continue;
            CrystalFXBeam beam = new CrystalFXBeam(this.tile.func_145831_w(), this.tile, (ICrystalLink)target);
            this.beamFXList.add(beam);
            BCEffectHandler.spawnGLParticle((IGLFXHandler)beam.getFXHandler(), (BCParticle)beam);
        }
    }

    @Override
    public void tileUnload() {
        super.tileUnload();
    }
}

