/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wcg.items;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.item.ItemNetworkItem;
import com.raoulvdberge.refinedstorage.tile.TileController;
import com.raoulvdberge.refinedstorage.tile.grid.TileGrid;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import p455w0rd.wcg.items.NetworkItemWirelessCraftingGrid;

public class ItemWirelessCraftingGrid
extends ItemNetworkItem {
    public ItemWirelessCraftingGrid() {
        super("wireless_crafting_grid");
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public void initializeDefaults(NBTTagCompound tag) {
        super.initializeDefaults(tag);
        tag.func_74768_a("ViewType", 0);
        tag.func_74768_a("SortingDirection", 1);
        tag.func_74768_a("SortingType", 0);
        tag.func_74768_a("SearchBoxMode", 0);
        tag.func_74757_a("Initialized", false);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileGrid gridTile;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == RSBlocks.GRID && (gridTile = (TileGrid)world.func_175625_s(pos)).getNetwork() != null) {
            BlockPos cPos = gridTile.getNetwork().getPosition();
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a("ControllerX", cPos.func_177958_n());
            tag.func_74768_a("ControllerY", cPos.func_177956_o());
            tag.func_74768_a("ControllerZ", cPos.func_177952_p());
            tag.func_74768_a("DimensionID", player.field_71093_bK);
            tag.func_74768_a("GridX", pos.func_177958_n());
            tag.func_74768_a("GridY", pos.func_177956_o());
            tag.func_74768_a("GridZ", pos.func_177952_p());
            this.initializeDefaults(tag);
            stack.func_77982_d(tag);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        TileEntity controller;
        WorldServer controllerWorld;
        if (!world.field_72995_K && this.isValid(stack) && (controllerWorld = DimensionManager.getWorld((int)ItemNetworkItem.getDimensionId((ItemStack)stack))) != null && (controller = controllerWorld.func_175625_s(new BlockPos(ItemNetworkItem.getX((ItemStack)stack), ItemNetworkItem.getY((ItemStack)stack), ItemNetworkItem.getZ((ItemStack)stack)))) instanceof TileController) {
            if (stack.func_77942_o()) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt.func_74764_b("Initialized") && !nbt.func_74767_n("Initialized")) {
                    nbt.func_74757_a("Initialized", true);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                if (((TileController)controller).getNetworkItemHandler().onOpen(player, (World)controllerWorld, hand)) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                if (this.getEnergyStored(stack) <= 0) {
                    player.func_145747_a((ITextComponent)new TextComponentString("No power"));
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:network_item.out_of_range", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:network_item.not_found", new Object[0]));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean isValid(ItemStack stack) {
        return super.isValid(stack) && stack.func_77978_p().func_74764_b("ViewType") && stack.func_77978_p().func_74764_b("SortingDirection") && stack.func_77978_p().func_74764_b("SortingType") && stack.func_77978_p().func_74764_b("SearchBoxMode") && this.getGridPos(stack) != null;
    }

    public INetworkItem provide(INetworkItemHandler handler, EntityPlayer player, ItemStack stack) {
        return new NetworkItemWirelessCraftingGrid(handler, player, stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (stack.func_77952_i() != 1) {
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:energy_stored", (Object[])new Object[]{this.getEnergyStored(stack), this.getMaxEnergyStored(stack)}));
        }
        if (this.isValid(stack)) {
            BlockPos pos = this.getGridPos(stack);
            tooltip.add("Linked to Grid at: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p());
        }
    }

    public BlockPos getGridPos(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("GridX") && tag.func_74764_b("GridY") && tag.func_74764_b("GridZ")) {
            return new BlockPos(tag.func_74762_e("GridX"), tag.func_74762_e("GridY"), tag.func_74762_e("GridZ"));
        }
        return null;
    }

    public static int getViewType(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("ViewType");
    }

    public static int getSortingType(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("SortingType");
    }

    public static int getSortingDirection(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("SortingDirection");
    }

    public static int getSearchBoxMode(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("SearchBoxMode");
    }
}

