/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.CoolantContainer;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.utils.FluidHelper;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityReactorCoolantPort
extends TileEntityReactorPart
implements ITickableMultiblockPart,
IInputOutputPort {
    @CapabilityInject(value=IFluidHandler.class)
    private static Capability<IFluidHandler> CAPAB_FLUID_HANDLER = null;
    private IInputOutputPort.Direction _direction = IInputOutputPort.Direction.Input;

    @Override
    public IInputOutputPort.Direction getDirection() {
        return this._direction;
    }

    @Override
    public void setDirection(IInputOutputPort.Direction direction, boolean markForUpdate) {
        if (direction == this._direction) {
            return;
        }
        this._direction = direction;
        World world = this.func_145831_w();
        if (WorldHelper.calledByLogicalServer((World)world)) {
            WorldHelper.notifyBlockUpdate((World)world, (BlockPos)this.getWorldPosition(), null, null);
            this.notifyOutwardNeighborsOfStateChange();
            if (markForUpdate) {
                this.func_70296_d();
            } else {
                this.notifyNeighborsOfTileChange();
            }
        } else {
            world.func_175704_b(this.getWorldPosition(), this.getWorldPosition());
            this.notifyNeighborsOfTileChange();
        }
    }

    @Override
    public void toggleDirection(boolean markForUpdate) {
        this.setDirection(this._direction.opposite(), markForUpdate);
    }

    public void onPostMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onPostMachineAssembled(multiblockControllerBase);
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.notifyOutwardNeighborsOfStateChange();
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (!data.func_74764_b("inlet")) {
            return;
        }
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this._direction = IInputOutputPort.Direction.from(data.func_74767_n("inlet"));
        } else {
            this.setDirection(IInputOutputPort.Direction.from(data.func_74767_n("inlet")), false);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.func_74757_a("inlet", this._direction.isInput());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return null != CAPAB_FLUID_HANDLER && CAPAB_FLUID_HANDLER == capability && this.isMachineAssembled() || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        MultiblockReactor reactor;
        if (null != CAPAB_FLUID_HANDLER && CAPAB_FLUID_HANDLER == capability && null != (reactor = this.getReactorController()) && reactor.isAssembled()) {
            return (T)CAPAB_FLUID_HANDLER.cast((Object)reactor.getFluidHandler(this._direction));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onMultiblockServerTick() {
        if (this._direction.isInput()) {
            return;
        }
        CoolantContainer cc = this.getReactorController().getCoolantContainer();
        FluidStack fluidToDrain = cc.drain(0, cc.getCapacity(), false);
        EnumFacing targetFacing = this.getOutwardFacing();
        if (fluidToDrain != null && fluidToDrain.amount > 0 && null != targetFacing) {
            fluidToDrain.amount = FluidHelper.fillAdjacentHandler((TileEntity)this, targetFacing, fluidToDrain, true);
            cc.drain(0, fluidToDrain, true);
        }
    }
}

