/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockDevice;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBearing;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.util.WorldHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTurbineRotorBearing
extends BlockMultiblockDevice {
    public BlockTurbineRotorBearing(String blockName) {
        super(PartType.TurbineRotorBearing, blockName);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTurbineRotorBearing();
    }

    @Override
    public void registerRecipes() {
        if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Legacy)) {
            GameRegistry.addRecipe((ItemStack)BrBlocks.turbineBearing.createItemStack(), (Object[])new Object[]{"HRH", "DDD", "HRH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Legacy, 1), Character.valueOf('D'), Items.field_151045_i, Character.valueOf('R'), BrBlocks.turbineRotorShaft.createItemStack(PartTier.Legacy, 1)});
        }
        if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Basic)) {
            GameRegistry.addRecipe((ItemStack)BrBlocks.turbineBearing.createItemStack(), (Object[])new Object[]{"HRH", "DDD", "HRH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Basic, 1), Character.valueOf('D'), Items.field_151045_i, Character.valueOf('R'), BrBlocks.turbineRotorShaft.createItemStack(PartTier.Basic, 1)});
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_176214_u() {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        TileEntityTurbineRotorBearing bearing;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTurbineRotorBearing && (bearing = (TileEntityTurbineRotorBearing)te).isConnected() && bearing.getTurbine().getActive()) {
            return bearing.getAABB();
        }
        return super.func_180646_a(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntityTurbineRotorBearing bearing;
        MultiblockTurbine turbine;
        if (BigReactors.CONFIG.disableTurbineParticles) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTurbineRotorBearing && (turbine = (bearing = (TileEntityTurbineRotorBearing)te).getTurbine()) != null && !turbine.isInteriorInvisible() && turbine.isAssembledAndActive()) {
            int numParticles = Math.min(20, Math.max(1, turbine.getFluidConsumedLastTick() / 40));
            BlockPos minCoord = turbine.getMinimumCoord().func_177982_a(1, 1, 1);
            BlockPos maxCoord = turbine.getMaximumCoord().func_177982_a(-1, -1, -1);
            EnumFacing inwardsDir = bearing.getOutwardFacing().func_176734_d();
            int offsetX = inwardsDir.func_82601_c();
            int offsetY = inwardsDir.func_96559_d();
            int offsetZ = inwardsDir.func_82599_e();
            EnumParticleTypes particle = BigReactors.VALENTINES_DAY ? EnumParticleTypes.HEART : EnumParticleTypes.CLOUD;
            int minX = minCoord.func_177958_n();
            int minY = minCoord.func_177956_o();
            int minZ = minCoord.func_177952_p();
            int maxX = maxCoord.func_177958_n();
            int maxY = maxCoord.func_177956_o();
            int maxZ = maxCoord.func_177952_p();
            if (offsetX != 0) {
                minX = maxX = bearing.getWorldPosition().func_177958_n() + offsetX;
            } else if (offsetY != 0) {
                minY = maxY = bearing.getWorldPosition().func_177956_o() + offsetY;
            } else {
                minZ = maxZ = bearing.getWorldPosition().func_177952_p() + offsetZ;
            }
            for (int i = 0; i < numParticles; ++i) {
                int particleX = minX + (int)(rand.nextFloat() * (float)(maxX - minX + 1));
                int particleY = minY + (int)(rand.nextFloat() * (float)(maxY - minY + 1));
                int particleZ = minZ + (int)(rand.nextFloat() * (float)(maxZ - minZ + 1));
                WorldHelper.spawnVanillaParticles((World)bearing.func_145831_w(), (EnumParticleTypes)particle, (int)1, (int)numParticles, (int)particleX, (int)particleY, (int)particleZ, (int)0, (int)0, (int)0);
            }
        }
    }
}

